/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.draft.json.ObjectMapperFactory;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.methods.Validator;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.UpdateMessagePatch;

public class UpdateMessagePatchValidator
implements Validator<ObjectNode> {
    private final ObjectMapper parser;

    @Inject
    @VisibleForTesting
    UpdateMessagePatchValidator(ObjectMapperFactory parserFactory) {
        this.parser = parserFactory.forParsing();
    }

    @Override
    public boolean isValid(ObjectNode patch) {
        return this.validate(patch).isEmpty();
    }

    @Override
    public Set<ValidationResult> validate(ObjectNode json) {
        try {
            this.parser.readValue(json.toString(), UpdateMessagePatch.class);
        }
        catch (JsonMappingException e) {
            return ImmutableSet.of((Object)ValidationResult.builder().property(this.firstFieldFrom(e.getPath()).orElse("__UNDEFINED__")).message(e.getMessage()).build());
        }
        catch (IOException e) {
            return ImmutableSet.of((Object)ValidationResult.builder().message(e.getMessage()).build());
        }
        return ImmutableSet.of();
    }

    private Optional<String> firstFieldFrom(List<JsonMappingException.Reference> references) {
        if (references == null) {
            throw new IllegalArgumentException("references");
        }
        return references.stream().map(JsonMappingException.Reference::getFieldName).map(MessageProperties.MessageProperty::valueOf).findFirst().map(MessageProperties.MessageProperty::asFieldName);
    }
}

