/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.predicates.ThrowingPredicate;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.jmap.draft.exceptions.AttachmentsNotFoundException;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;

public class AttachmentChecker {
    private final AttachmentManager attachmentManager;

    @Inject
    public AttachmentChecker(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void assertAttachmentsExist(ValueWithId.CreationMessageEntry entry, MailboxSession session) throws AttachmentsNotFoundException, MailboxException {
        ImmutableList<Attachment> attachments = ((CreationMessage)entry.getValue()).getAttachments();
        List<BlobId> notFounds = this.listAttachmentsNotFound((List<Attachment>)attachments, session);
        if (!notFounds.isEmpty()) {
            throw new AttachmentsNotFoundException(notFounds);
        }
    }

    private List<BlobId> listAttachmentsNotFound(List<Attachment> attachments, MailboxSession session) throws MailboxException {
        ThrowingPredicate notExists = attachment -> !this.attachmentManager.exists(this.getAttachmentId((Attachment)attachment), session);
        return (List)attachments.stream().filter(Throwing.predicate((ThrowingPredicate)notExists).sneakyThrow()).map(Attachment::getBlobId).collect(Guavate.toImmutableList());
    }

    private AttachmentId getAttachmentId(Attachment attachment) {
        return AttachmentId.from((String)attachment.getBlobId().getRawValue());
    }
}

