/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3;

import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.Mailbox;

public class POP3SessionImpl
extends ProtocolSessionImpl
implements POP3Session {
    private static final Response LINE_TOO_LONG = new POP3Response("-ERR", "Exceed maximal line length").immutable();
    private int handlerState;
    private Mailbox mailbox;

    public POP3SessionImpl(ProtocolTransport transport, ProtocolConfiguration configData) {
        super(transport, configData);
    }

    @Override
    public int getHandlerState() {
        return this.handlerState;
    }

    @Override
    public void setHandlerState(int handlerState) {
        this.handlerState = handlerState;
    }

    public void resetState() {
        this.getState().clear();
        this.setHandlerState(0);
    }

    @Override
    public Mailbox getUserMailbox() {
        return this.mailbox;
    }

    @Override
    public void setUserMailbox(Mailbox mailbox) {
        this.mailbox = mailbox;
    }

    public Response newLineTooLongResponse() {
        return LINE_TOO_LONG;
    }

    public Response newFatalErrorResponse() {
        return POP3Response.ERR;
    }
}

