/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;

public enum BlobExportImplChoice {
    LOCAL_FILE("localFile"),
    LINSHARE("linshare");

    private static final String BLOB_EXPORT_MECHANISM_IMPL = "blob.export.implementation";
    private final String name;

    private static Optional<BlobExportImplChoice> from(String implNameString) {
        Preconditions.checkNotNull((Object)implNameString);
        return Stream.of(BlobExportImplChoice.values()).filter(impl -> impl.name.equals(implNameString)).findFirst();
    }

    private static ImmutableList<String> plainImplNames() {
        return (ImmutableList)Stream.of(BlobExportImplChoice.values()).map(impl -> impl.name).collect(Guavate.toImmutableList());
    }

    static Optional<BlobExportImplChoice> from(Configuration configuration) {
        String blobExportImpl = configuration.getString(BLOB_EXPORT_MECHANISM_IMPL);
        Optional<String> sanitizedImplName = Optional.ofNullable(blobExportImpl).map(String::trim);
        return sanitizedImplName.map(name -> BlobExportImplChoice.from(name).orElseThrow(() -> new IllegalArgumentException(BlobExportImplChoice.unknownBlobExportErrorMessage(name))));
    }

    private static String unknownBlobExportErrorMessage(String blobExportImpl) {
        return String.format("unknown blob export mechanism '%s', please choose one in supported implementations(%s)", blobExportImpl, Joiner.on((String)",").join(BlobExportImplChoice.plainImplNames()));
    }

    private BlobExportImplChoice(String name) {
        this.name = name;
    }

    String getImplName() {
        return this.name;
    }
}

