/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerMain;
import org.apache.james.SearchConfiguration;
import org.apache.james.SearchModuleChooser;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;
import org.apache.james.modules.BlobExportMechanismModule;
import org.apache.james.modules.CassandraConsistencyTaskSerializationModule;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.data.CassandraDLPConfigurationStoreModule;
import org.apache.james.modules.data.CassandraDomainListModule;
import org.apache.james.modules.data.CassandraJmapModule;
import org.apache.james.modules.data.CassandraRecipientRewriteTableModule;
import org.apache.james.modules.data.CassandraSieveRepositoryModule;
import org.apache.james.modules.data.CassandraUsersRepositoryModule;
import org.apache.james.modules.eventstore.CassandraEventStoreModule;
import org.apache.james.modules.mailbox.BlobStoreAPIModule;
import org.apache.james.modules.mailbox.CassandraBlobStoreDependenciesModule;
import org.apache.james.modules.mailbox.CassandraBlobStoreModule;
import org.apache.james.modules.mailbox.CassandraBucketModule;
import org.apache.james.modules.mailbox.CassandraDeletedMessageVaultModule;
import org.apache.james.modules.mailbox.CassandraMailboxModule;
import org.apache.james.modules.mailbox.CassandraQuotaMailingModule;
import org.apache.james.modules.mailbox.CassandraSessionModule;
import org.apache.james.modules.mailbox.TikaMailboxModule;
import org.apache.james.modules.mailrepository.CassandraMailRepositoryModule;
import org.apache.james.modules.metrics.CassandraMetricsModule;
import org.apache.james.modules.protocols.IMAPServerModule;
import org.apache.james.modules.protocols.JMAPServerModule;
import org.apache.james.modules.protocols.JmapEventBusModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.activemq.ActiveMQQueueModule;
import org.apache.james.modules.server.DKIMMailetModule;
import org.apache.james.modules.server.DLPRoutesModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.ElasticSearchMetricReporterModule;
import org.apache.james.modules.server.InconsistencyQuotasSolvingRoutesModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.JmapTasksModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.MailboxesExportRoutesModule;
import org.apache.james.modules.server.MessagesRoutesModule;
import org.apache.james.modules.server.SieveRoutesModule;
import org.apache.james.modules.server.SwaggerRoutesModule;
import org.apache.james.modules.server.TaskManagerModule;
import org.apache.james.modules.server.WebAdminMailOverWebModule;
import org.apache.james.modules.server.WebAdminReIndexingTaskSerializationModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.modules.spamassassin.SpamAssassinListenerModule;
import org.apache.james.modules.vault.DeletedMessageVaultRoutesModule;
import org.apache.james.modules.webadmin.CassandraRoutesModule;
import org.apache.james.modules.webadmin.InconsistencySolvingRoutesModule;
import org.apache.james.server.core.configuration.Configuration;

public class CassandraJamesServerMain
implements JamesServerMain {
    public static final Module WEBADMIN = Modules.combine((Module[])new Module[]{new CassandraRoutesModule(), new DataRoutesModules(), new DeletedMessageVaultRoutesModule(), new DLPRoutesModule(), new InconsistencyQuotasSolvingRoutesModule(), new InconsistencySolvingRoutesModule(), new JmapTasksModule(), new MailboxesExportRoutesModule(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new SieveRoutesModule(), new SwaggerRoutesModule(), new WebAdminServerModule(), new WebAdminReIndexingTaskSerializationModule(), new MessagesRoutesModule(), new WebAdminMailOverWebModule()});
    public static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new CassandraJmapModule(), new IMAPServerModule(), new LMTPServerModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), new JMAPServerModule(), new JmapEventBusModule(), WEBADMIN});
    public static final Module PLUGINS = Modules.combine((Module)new CassandraQuotaMailingModule());
    private static final Module BLOB_MODULE = Modules.combine((Module[])new Module[]{new BlobStoreAPIModule(), new BlobExportMechanismModule()});
    private static final Module CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE = binder -> binder.bind(new TypeLiteral<Set<DTOModule<?, ? extends DTO>>>(){}).annotatedWith((Annotation)Names.named((String)"EventNestedTypes")).toInstance((Object)ImmutableSet.of());
    public static final Module CASSANDRA_SERVER_CORE_MODULE = Modules.combine((Module[])new Module[]{new ActiveMQQueueModule(), new CassandraBlobStoreDependenciesModule(), new CassandraDomainListModule(), new CassandraDLPConfigurationStoreModule(), new CassandraEventStoreModule(), new CassandraMailRepositoryModule(), new CassandraMetricsModule(), new CassandraRecipientRewriteTableModule(), new CassandraSessionModule(), new CassandraSieveRepositoryModule(), new ElasticSearchMetricReporterModule(), BLOB_MODULE, CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE});
    public static final Module CASSANDRA_MAILBOX_MODULE = Modules.combine((Module[])new Module[]{new CassandraConsistencyTaskSerializationModule(), new CassandraMailboxModule(), new CassandraDeletedMessageVaultModule(), new MailboxModule(), new TikaMailboxModule(), new SpamAssassinListenerModule()});
    public static Module REQUIRE_TASK_MANAGER_MODULE = Modules.combine((Module[])new Module[]{CASSANDRA_SERVER_CORE_MODULE, CASSANDRA_MAILBOX_MODULE, PROTOCOLS, PLUGINS, new DKIMMailetModule()});
    protected static Module ALL_BUT_JMX_CASSANDRA_MODULE = Modules.combine((Module[])new Module[]{new CassandraBucketModule(), new CassandraBlobStoreModule(), REQUIRE_TASK_MANAGER_MODULE, new TaskManagerModule(), CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE});

    public static void main(String[] args) throws Exception {
        CassandraJamesServerConfiguration configuration = CassandraJamesServerConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = CassandraJamesServerMain.createServer(configuration).combineWith(new Module[]{new JMXServerModule()});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(CassandraJamesServerConfiguration configuration) {
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{ALL_BUT_JMX_CASSANDRA_MODULE}).combineWith((Collection)SearchModuleChooser.chooseModules((SearchConfiguration)configuration.searchConfiguration())).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new CassandraUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation()));
    }
}

