/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.CassandraMappingsService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

@Api(tags={"Cassandra Mappings Operations"})
@Path(value="cassandra/mappings")
@Produces(value={"application/json"})
public class CassandraMappingsRoutes
implements Routes {
    public static final String ROOT_PATH = "cassandra/mappings";
    private static final TaskRegistrationKey SOLVE_INCONSISTENCIES = TaskRegistrationKey.of((String)"SolveInconsistencies");
    private final CassandraMappingsService cassandraMappingsService;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private static final String INVALID_ACTION_ARGUMENT_REQUEST = "Invalid action argument for performing operation on mappings data";
    private static final String ACTION_REQUEST_CAN_NOT_BE_DONE = "The action requested for performing operation on mappings data cannot be performed";

    @Inject
    CassandraMappingsRoutes(CassandraMappingsService cassandraMappingsService, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.cassandraMappingsService = cassandraMappingsService;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.post(ROOT_PATH, this.performActionOnMappings(), (ResponseTransformer)this.jsonTransformer);
    }

    @POST
    @Path(value="cassandra/mappings")
    @ApiOperation(value="Performing operations on cassandra data mappings")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="String", name="action", paramType="query", example="?action=SolveInconsistencies", value="Specify the action to perform on mappings. For now only 'SolveInconsistencies' is supported as an action, and its purpose is to clean 'mappings_sources' projection table and repopulate it.")})
    @ApiResponses(value={@ApiResponse(code=201, message="The taskId of the given scheduled task", response=TaskIdDto.class, responseHeaders={@ResponseHeader(name="Location", description="URL of the resource associated with the scheduled task")}), @ApiResponse(code=400, message="Invalid action argument for performing operation on mappings data"), @ApiResponse(code=500, message="The action requested for performing operation on mappings data cannot be performed")})
    public Route performActionOnMappings() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)SOLVE_INCONSISTENCIES, request -> this.cassandraMappingsService.solveMappingsSourcesInconsistencies()).asRoute(this.taskManager);
    }
}

