/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.io.IOException;
import org.apache.james.blob.api.BlobId;

public class HashBlobId
implements BlobId {
    private final String id;

    @VisibleForTesting
    HashBlobId(String id) {
        this.id = id;
    }

    @Override
    public String asString() {
        return this.id;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof HashBlobId) {
            HashBlobId other = (HashBlobId)obj;
            return Objects.equal((Object)this.id, (Object)other.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public static class Factory
    implements BlobId.Factory {
        @Override
        public HashBlobId forPayload(byte[] payload) {
            Preconditions.checkArgument((payload != null ? 1 : 0) != 0);
            return new HashBlobId(Hashing.sha256().hashBytes(payload).toString());
        }

        @Override
        public BlobId forPayload(ByteSource payload) {
            try {
                return new HashBlobId(payload.hash(Hashing.sha256()).toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public HashBlobId from(String id) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
            return new HashBlobId(id);
        }
    }
}

