/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraBucketDAO {
    private final BlobId.Factory blobIdFactory;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insert;
    private final PreparedStatement insertPart;
    private final PreparedStatement select;
    private final PreparedStatement selectPart;
    private final PreparedStatement delete;
    private final PreparedStatement deleteParts;
    private final PreparedStatement listAll;

    @Inject
    @VisibleForTesting
    public CassandraBucketDAO(BlobId.Factory blobIdFactory, Session session) {
        this.blobIdFactory = blobIdFactory;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insert = this.prepareInsert(session);
        this.select = this.prepareSelect(session);
        this.delete = this.prepareDelete(session);
        this.insertPart = this.prepareInsertPart(session);
        this.selectPart = this.prepareSelectPart(session);
        this.deleteParts = this.prepareDeleteParts(session);
        this.listAll = this.prepareListAll(session);
    }

    private PreparedStatement prepareDeleteParts(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("blobPartsInBucket").where(QueryBuilder.eq((String)"bucket", (Object)QueryBuilder.bindMarker((String)"bucket"))).and(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("blobsInBucket").where(QueryBuilder.eq((String)"bucket", (Object)QueryBuilder.bindMarker((String)"bucket"))).and(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareListAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("blobsInBucket"));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("blobsInBucket").where(QueryBuilder.eq((String)"bucket", (Object)QueryBuilder.bindMarker((String)"bucket"))).and(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareSelectPart(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("blobPartsInBucket").where(QueryBuilder.eq((String)"bucket", (Object)QueryBuilder.bindMarker((String)"bucket"))).and(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).and(QueryBuilder.eq((String)"chunkNumber", (Object)QueryBuilder.bindMarker((String)"chunkNumber"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"blobsInBucket").value("bucket", (Object)QueryBuilder.bindMarker((String)"bucket")).value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("position", (Object)QueryBuilder.bindMarker((String)"position")));
    }

    private PreparedStatement prepareInsertPart(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"blobPartsInBucket").value("bucket", (Object)QueryBuilder.bindMarker((String)"bucket")).value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("chunkNumber", (Object)QueryBuilder.bindMarker((String)"chunkNumber")).value("data", (Object)QueryBuilder.bindMarker((String)"data")));
    }

    Mono<Void> writePart(ByteBuffer data, BucketName bucketName, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertPart.bind().setString("bucket", bucketName.asString()).setString("id", blobId.asString()).setInt("chunkNumber", position).setBytes("data", data));
    }

    Mono<Void> saveBlobPartsReferences(BucketName bucketName, BlobId blobId, int numberOfChunk) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insert.bind().setString("bucket", bucketName.asString()).setString("id", blobId.asString()).setInt("position", numberOfChunk));
    }

    Mono<Integer> selectRowCount(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind().setString("bucket", bucketName.asString()).setString("id", blobId.asString())).map(row -> row.getInt("position"));
    }

    Mono<ByteBuffer> readPart(BucketName bucketName, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectPart.bind().setString("bucket", bucketName.asString()).setString("id", blobId.asString()).setInt("chunkNumber", position)).map(this::rowToData);
    }

    Mono<Void> deletePosition(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setString("bucket", bucketName.asString()).setString("id", blobId.asString()));
    }

    Mono<Void> deleteParts(BucketName bucketName, BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteParts.bind().setString("bucket", bucketName.asString()).setString("id", blobId.asString()));
    }

    public Flux<Pair<BucketName, BlobId>> listAll() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listAll.bind()).map(row -> Pair.of((Object)BucketName.of((String)row.getString("bucket")), (Object)this.blobIdFactory.from(row.getString("id"))));
    }

    private ByteBuffer rowToData(Row row) {
        return row.getBytes("data");
    }
}

