/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.StorageInformation;

public class DeletedMessageWithStorageInformationDTO {
    private final DeletedMessageDTO deletedMessage;
    private final StorageInformationDTO storageInformation;

    public static DeletedMessageWithStorageInformationDTO toDTO(DeletedMessageWithStorageInformation deletedMessageWithStorageInformation) {
        return new DeletedMessageWithStorageInformationDTO(DeletedMessageDTO.toDTO(deletedMessageWithStorageInformation.getDeletedMessage()), StorageInformationDTO.toDTO(deletedMessageWithStorageInformation.getStorageInformation()));
    }

    @JsonCreator
    public DeletedMessageWithStorageInformationDTO(@JsonProperty(value="deletedMessage") DeletedMessageDTO deletedMessage, @JsonProperty(value="storageInformation") StorageInformationDTO storageInformation) {
        this.deletedMessage = deletedMessage;
        this.storageInformation = storageInformation;
    }

    public DeletedMessageDTO getDeletedMessage() {
        return this.deletedMessage;
    }

    public StorageInformationDTO getStorageInformation() {
        return this.storageInformation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.deletedMessage.messageId).add("originMailboxes", this.deletedMessage.originMailboxes).add("owner", (Object)this.deletedMessage.owner).add("deliveryDate", (Object)this.deletedMessage.deliveryDate).add("deletionDate", (Object)this.deletedMessage.deletionDate).add("sender", (Object)this.deletedMessage.sender).add("recipients", this.deletedMessage.recipients).add("hasAttachment", this.deletedMessage.hasAttachment).add("size", this.deletedMessage.size).add("subject", this.deletedMessage.subject).add("bucketName", (Object)this.storageInformation.bucketName).add("blobId", (Object)this.storageInformation.blobId).toString();
    }

    public static class DeletedMessageDTO {
        private final String messageId;
        private final List<String> originMailboxes;
        private final String owner;
        private final String deliveryDate;
        private final String deletionDate;
        private final String sender;
        private final List<String> recipients;
        private final Optional<String> subject;
        private final boolean hasAttachment;
        private final long size;

        public static DeletedMessageDTO toDTO(DeletedMessage deletedMessage) {
            return new DeletedMessageDTO(deletedMessage.getMessageId().serialize(), (List<String>)DeletedMessageDTO.serializeOriginMailboxes(deletedMessage.getOriginMailboxes()), deletedMessage.getOwner().asString(), DeletedMessageDTO.serializeZonedDateTime(deletedMessage.getDeliveryDate()), DeletedMessageDTO.serializeZonedDateTime(deletedMessage.getDeletionDate()), deletedMessage.getSender().asString(), (List<String>)DeletedMessageDTO.serializeRecipients(deletedMessage.getRecipients()), deletedMessage.getSubject(), deletedMessage.hasAttachment(), deletedMessage.getSize());
        }

        private static ImmutableList<String> serializeOriginMailboxes(List<MailboxId> originMailboxes) {
            return (ImmutableList)originMailboxes.stream().map(MailboxId::serialize).collect(Guavate.toImmutableList());
        }

        private static ImmutableList<String> serializeRecipients(List<MailAddress> recipients) {
            return (ImmutableList)recipients.stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
        }

        private static String serializeZonedDateTime(ZonedDateTime time) {
            return time.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }

        @JsonCreator
        public DeletedMessageDTO(@JsonProperty(value="messageId") String messageId, @JsonProperty(value="originMailboxes") List<String> originMailboxes, @JsonProperty(value="owner") String owner, @JsonProperty(value="deliveryDate") String deliveryDate, @JsonProperty(value="deletionDate") String deletionDate, @JsonProperty(value="sender") String sender, @JsonProperty(value="recipients") List<String> recipients, @JsonProperty(value="subject") Optional<String> subject, @JsonProperty(value="hasAttachment") boolean hasAttachment, @JsonProperty(value="size") long size) {
            this.messageId = messageId;
            this.originMailboxes = originMailboxes;
            this.owner = owner;
            this.deliveryDate = deliveryDate;
            this.deletionDate = deletionDate;
            this.sender = sender;
            this.recipients = recipients;
            this.subject = subject;
            this.hasAttachment = hasAttachment;
            this.size = size;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public List<String> getOriginMailboxes() {
            return this.originMailboxes;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getDeliveryDate() {
            return this.deliveryDate;
        }

        public String getDeletionDate() {
            return this.deletionDate;
        }

        public String getSender() {
            return this.sender;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }

        public Optional<String> getSubject() {
            return this.subject;
        }

        public boolean getHasAttachment() {
            return this.hasAttachment;
        }

        public long getSize() {
            return this.size;
        }
    }

    public static class StorageInformationDTO {
        private final String bucketName;
        private final String blobId;

        public static StorageInformationDTO toDTO(StorageInformation storageInformation) {
            return new StorageInformationDTO(storageInformation.getBucketName().asString(), storageInformation.getBlobId().asString());
        }

        @JsonCreator
        public StorageInformationDTO(@JsonProperty(value="bucketName") String bucketName, @JsonProperty(value="blobId") String blobId) {
            Preconditions.checkNotNull((Object)bucketName);
            Preconditions.checkNotNull((Object)blobId);
            this.bucketName = bucketName;
            this.blobId = blobId;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getBlobId() {
            return this.blobId;
        }
    }
}

