/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;

public interface ProtocolMDCContextFactory {
    public Closeable from(Protocol var1, ChannelHandlerContext var2);

    public static MDCBuilder mdcContext(Protocol protocol, ChannelHandlerContext ctx) {
        return MDCBuilder.create().addContext(ProtocolMDCContextFactory.from(ctx.getAttachment())).addContext("protocol", (Object)protocol.getName()).addContext("ip", (Object)ProtocolMDCContextFactory.retrieveIp(ctx)).addContext("host", (Object)ProtocolMDCContextFactory.retrieveHost(ctx));
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    private static MDCBuilder from(Object o) {
        return Optional.ofNullable(o).filter(object -> object instanceof ProtocolSession).map(object -> (ProtocolSession)object).map(ProtocolMDCContextFactory::forSession).orElse(MDCBuilder.create());
    }

    public static MDCBuilder forSession(ProtocolSession protocolSession) {
        return MDCBuilder.create().addContext("sessionId", (Object)protocolSession.getSessionID()).addContext("charset", (Object)protocolSession.getCharset().displayName()).addContext("user", Optional.ofNullable(protocolSession.getUsername()).map(Username::asString));
    }

    public static class Standard
    implements ProtocolMDCContextFactory {
        @Override
        public Closeable from(Protocol protocol, ChannelHandlerContext ctx) {
            return ProtocolMDCContextFactory.mdcContext(protocol, ctx).build();
        }
    }
}

