/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    private static final boolean PARALLEL = true;

    @SafeVarargs
    public static <T> Stream<T> ofNullables(T ... array) {
        return StreamUtils.ofNullable(array);
    }

    public static <T> Stream<T> ofNullable(T[] array) {
        return StreamUtils.ofOptional(Optional.ofNullable(array));
    }

    public static <T> Stream<T> ofOptional(Optional<T[]> array) {
        return array.map(Arrays::stream).orElse(Stream.empty());
    }

    public static <T> Stream<T> flatten(Collection<Stream<T>> streams) {
        return StreamUtils.flatten(streams.stream());
    }

    public static <T> Stream<T> flatten(Stream<Stream<T>> streams) {
        return streams.flatMap(Function.identity());
    }

    public static <T> boolean isSingleValued(Stream<T> stream) {
        return stream.distinct().limit(2L).count() == 1L;
    }

    @SafeVarargs
    public static <T> Stream<T> flatten(Stream<T> ... streams) {
        return StreamUtils.flatten(Arrays.stream(streams));
    }

    public static <T> Stream<T> unfold(T seed, Function<T, Optional<T>> generator) {
        return StreamSupport.stream(new UnfoldSpliterator<T>(seed, generator), false);
    }

    public static <T> Stream<T> iterate(T seed, Long limit, Function<T, Stream<T>> generator) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (String)"StreamUtils.iterate have a given limit '{}', while it should not be negative", (Object)limit);
        return StreamUtils.unfold(Arrays.asList(seed), StreamUtils.conservativeGenerator(generator)).limit(limit + 1L).flatMap(Collection::stream);
    }

    private static <T> Function<List<T>, Optional<List<T>>> conservativeGenerator(Function<T, Stream<T>> generator) {
        return previous -> {
            List generated = (List)previous.stream().flatMap(generator).collect(Guavate.toImmutableList());
            if (generated.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(generated);
        };
    }

    private static class UnfoldSpliterator<T>
    implements Spliterator<T> {
        private static final Spliterator<?> NOT_ABLE_TO_SPLIT_SPLITERATOR = null;
        private Optional<T> current;
        private final Function<T, Optional<T>> generator;

        private UnfoldSpliterator(T seed, Function<T, Optional<T>> generator) {
            this.current = Optional.of(seed);
            this.generator = generator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            this.current.ifPresent(action);
            this.current = this.current.flatMap(this.generator);
            return this.current.isPresent();
        }

        @Override
        public Spliterator<T> trySplit() {
            return NOT_ABLE_TO_SPLIT_SPLITERATOR;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }
}

