/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7.query;

import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.mailbox.elasticsearch.v7.query.DateResolutionFormatter;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;

public class CriterionConverter {
    private final Map<Class<?>, Function<SearchQuery.Criterion, QueryBuilder>> criterionConverterMap = new HashMap();
    private final Map<Class<?>, BiFunction<String, SearchQuery.HeaderOperator, QueryBuilder>> headerOperatorConverterMap = new HashMap();

    public CriterionConverter() {
        this.registerCriterionConverters();
        this.registerHeaderOperatorConverters();
    }

    private void registerCriterionConverters() {
        this.registerCriterionConverter(SearchQuery.FlagCriterion.class, this::convertFlag);
        this.registerCriterionConverter(SearchQuery.UidCriterion.class, this::convertUid);
        this.registerCriterionConverter(SearchQuery.ConjunctionCriterion.class, this::convertConjunction);
        this.registerCriterionConverter(SearchQuery.HeaderCriterion.class, this::convertHeader);
        this.registerCriterionConverter(SearchQuery.TextCriterion.class, this::convertTextCriterion);
        this.registerCriterionConverter(SearchQuery.CustomFlagCriterion.class, this::convertCustomFlagCriterion);
        this.registerCriterionConverter(SearchQuery.AllCriterion.class, criterion -> QueryBuilders.matchAllQuery());
        this.registerCriterionConverter(SearchQuery.ModSeqCriterion.class, criterion -> this.createNumericFilter("modSeq", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.SizeCriterion.class, criterion -> this.createNumericFilter("size", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.InternalDateCriterion.class, criterion -> this.dateRangeFilter("date", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.AttachmentCriterion.class, this::convertAttachmentCriterion);
        this.registerCriterionConverter(SearchQuery.MimeMessageIDCriterion.class, this::convertMimeMessageIDCriterion);
    }

    private <T extends SearchQuery.Criterion> void registerCriterionConverter(Class<T> type, Function<T, QueryBuilder> f) {
        this.criterionConverterMap.put(type, f);
    }

    private void registerHeaderOperatorConverters() {
        this.registerHeaderOperatorConverter(SearchQuery.ExistsOperator.class, (headerName, operator) -> QueryBuilders.nestedQuery((String)"headers", (QueryBuilder)QueryBuilders.termQuery((String)"headers.name", (String)headerName), (ScoreMode)ScoreMode.Avg));
        this.registerHeaderOperatorConverter(SearchQuery.AddressOperator.class, (headerName, operator) -> this.manageAddressFields((String)headerName, operator.getAddress()));
        this.registerHeaderOperatorConverter(SearchQuery.DateOperator.class, (headerName, operator) -> this.dateRangeFilter("sentDate", (SearchQuery.DateOperator)operator));
        this.registerHeaderOperatorConverter(SearchQuery.ContainsOperator.class, (headerName, operator) -> QueryBuilders.nestedQuery((String)"headers", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"headers.name", (String)headerName)).must((QueryBuilder)QueryBuilders.matchQuery((String)"headers.value", (Object)operator.getValue())), (ScoreMode)ScoreMode.Avg));
    }

    private <T extends SearchQuery.HeaderOperator> void registerHeaderOperatorConverter(Class<T> type, BiFunction<String, T, QueryBuilder> f) {
        this.headerOperatorConverterMap.put(type, f);
    }

    public QueryBuilder convertCriterion(SearchQuery.Criterion criterion) {
        return this.criterionConverterMap.get(criterion.getClass()).apply(criterion);
    }

    private QueryBuilder convertAttachmentCriterion(SearchQuery.AttachmentCriterion criterion) {
        return QueryBuilders.termQuery((String)"hasAttachment", (boolean)criterion.getOperator().isSet());
    }

    private QueryBuilder convertMimeMessageIDCriterion(SearchQuery.MimeMessageIDCriterion criterion) {
        return QueryBuilders.termQuery((String)"mimeMessageID", (String)criterion.getMessageID());
    }

    private QueryBuilder convertCustomFlagCriterion(SearchQuery.CustomFlagCriterion criterion) {
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"userFlags", (String)criterion.getFlag());
        if (criterion.getOperator().isSet()) {
            return termQueryBuilder;
        }
        return QueryBuilders.boolQuery().mustNot((QueryBuilder)termQueryBuilder);
    }

    private QueryBuilder convertTextCriterion(SearchQuery.TextCriterion textCriterion) {
        switch (textCriterion.getType()) {
            case BODY: {
                return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"textBody", (Object)textCriterion.getOperator().getValue())).should((QueryBuilder)QueryBuilders.matchQuery((String)"htmlBody", (Object)textCriterion.getOperator().getValue()));
            }
            case FULL: {
                return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"textBody", (Object)textCriterion.getOperator().getValue())).should((QueryBuilder)QueryBuilders.matchQuery((String)"htmlBody", (Object)textCriterion.getOperator().getValue())).should((QueryBuilder)QueryBuilders.matchQuery((String)"attachments.textContent", (Object)textCriterion.getOperator().getValue()));
            }
            case ATTACHMENTS: {
                return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"attachments.textContent", (Object)textCriterion.getOperator().getValue()));
            }
            case ATTACHMENT_FILE_NAME: {
                return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"attachments.fileName", (String)textCriterion.getOperator().getValue()));
            }
        }
        throw new RuntimeException("Unknown SCOPE for text criterion");
    }

    private QueryBuilder dateRangeFilter(String field, SearchQuery.DateOperator dateOperator) {
        return QueryBuilders.boolQuery().filter(this.convertDateOperator(field, dateOperator.getType(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormatter.computeLowerDate(DateResolutionFormatter.convertDateToZonedDateTime(dateOperator.getDate()), dateOperator.getDateResultion())), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormatter.computeUpperDate(DateResolutionFormatter.convertDateToZonedDateTime(dateOperator.getDate()), dateOperator.getDateResultion()))));
    }

    private BoolQueryBuilder convertConjunction(SearchQuery.ConjunctionCriterion criterion) {
        return this.convertToBoolQuery(criterion.getCriteria().stream().map(this::convertCriterion), this.convertConjunctionType(criterion.getType()));
    }

    private BiFunction<BoolQueryBuilder, QueryBuilder, BoolQueryBuilder> convertConjunctionType(SearchQuery.Conjunction type) {
        switch (type) {
            case AND: {
                return BoolQueryBuilder::must;
            }
            case OR: {
                return BoolQueryBuilder::should;
            }
            case NOR: {
                return BoolQueryBuilder::mustNot;
            }
        }
        throw new RuntimeException("Unexpected conjunction criteria " + type);
    }

    private BoolQueryBuilder convertToBoolQuery(Stream<QueryBuilder> stream, BiFunction<BoolQueryBuilder, QueryBuilder, BoolQueryBuilder> addCriterionToBoolQuery) {
        return stream.collect(Collector.of(QueryBuilders::boolQuery, addCriterionToBoolQuery::apply, addCriterionToBoolQuery::apply, new Collector.Characteristics[0]));
    }

    private QueryBuilder convertFlag(SearchQuery.FlagCriterion flagCriterion) {
        SearchQuery.BooleanOperator operator = flagCriterion.getOperator();
        Flags.Flag flag = flagCriterion.getFlag();
        if (flag.equals(Flags.Flag.DELETED)) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"isDeleted", (boolean)operator.isSet()));
        }
        if (flag.equals(Flags.Flag.ANSWERED)) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"isAnswered", (boolean)operator.isSet()));
        }
        if (flag.equals(Flags.Flag.DRAFT)) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"isDraft", (boolean)operator.isSet()));
        }
        if (flag.equals(Flags.Flag.SEEN)) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"isUnread", (!operator.isSet() ? 1 : 0) != 0));
        }
        if (flag.equals(Flags.Flag.RECENT)) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"isRecent", (boolean)operator.isSet()));
        }
        if (flag.equals(Flags.Flag.FLAGGED)) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"isFlagged", (boolean)operator.isSet()));
        }
        throw new RuntimeException("Unknown flag used in Flag search criterion");
    }

    private QueryBuilder createNumericFilter(String fieldName, SearchQuery.NumericOperator operator) {
        switch (operator.getType()) {
            case EQUALS: {
                return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gte((Object)operator.getValue()).lte((Object)operator.getValue()));
            }
            case GREATER_THAN: {
                return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gt((Object)operator.getValue()));
            }
            case LESS_THAN: {
                return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).lt((Object)operator.getValue()));
            }
        }
        throw new RuntimeException("A non existing numeric operator was triggered");
    }

    private BoolQueryBuilder convertUid(SearchQuery.UidCriterion uidCriterion) {
        if (uidCriterion.getOperator().getRange().length == 0) {
            return QueryBuilders.boolQuery();
        }
        return QueryBuilders.boolQuery().filter((QueryBuilder)this.convertToBoolQuery(Arrays.stream(uidCriterion.getOperator().getRange()).map(this::uidRangeFilter), BoolQueryBuilder::should));
    }

    private QueryBuilder uidRangeFilter(SearchQuery.UidRange numericRange) {
        return QueryBuilders.rangeQuery((String)"uid").lte((Object)numericRange.getHighValue().asLong()).gte((Object)numericRange.getLowValue().asLong());
    }

    private QueryBuilder convertHeader(SearchQuery.HeaderCriterion headerCriterion) {
        return this.headerOperatorConverterMap.get(headerCriterion.getOperator().getClass()).apply(headerCriterion.getHeaderName().toLowerCase(Locale.US), headerCriterion.getOperator());
    }

    private QueryBuilder manageAddressFields(String headerName, String value) {
        return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)(this.getFieldNameFromHeaderName(headerName) + ".name"), (Object)value)).should((QueryBuilder)QueryBuilders.matchQuery((String)(this.getFieldNameFromHeaderName(headerName) + ".address"), (Object)value)).should((QueryBuilder)QueryBuilders.matchQuery((String)(this.getFieldNameFromHeaderName(headerName) + ".address.raw"), (Object)value));
    }

    private String getFieldNameFromHeaderName(String headerName) {
        switch (headerName.toLowerCase(Locale.US)) {
            case "to": {
                return "to";
            }
            case "cc": {
                return "cc";
            }
            case "bcc": {
                return "bcc";
            }
            case "from": {
                return "from";
            }
        }
        throw new RuntimeException("Header not recognized as Addess Header : " + headerName);
    }

    private QueryBuilder convertDateOperator(String field, SearchQuery.DateComparator dateComparator, String lowDateString, String upDateString) {
        switch (dateComparator) {
            case BEFORE: {
                return QueryBuilders.rangeQuery((String)field).lte((Object)upDateString);
            }
            case AFTER: {
                return QueryBuilders.rangeQuery((String)field).gt((Object)lowDateString);
            }
            case ON: {
                return QueryBuilders.rangeQuery((String)field).lte((Object)upDateString).gte((Object)lowDateString);
            }
        }
        throw new RuntimeException("Unknown date operator");
    }
}

