/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.numeric;
import eu.timepit.refined.string;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.UploadSerializer;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.jmap.routes.TooBigUploadException;
import org.apache.james.jmap.routes.UploadResponse;
import org.apache.james.jmap.routes.UploadRoutes$;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tUv!B\u0012%\u0011\u0003yc!B\u0019%\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001f\u0006\t\u0011\u000b\u0001!\u0012\u0005\bI\u0006\u0011\r\u0011\"\u0001f\u0011\u0019A\u0017\u0001)A\u0005M\")\u0011.\u0001C\u0001U\u001a!\u0011\u0007\n\u0001n\u0011!Q\u0018B!b\u0001\n\u0003Y\b\"CA\u0003\u0013\t\u0005\t\u0015!\u0003}\u0011)\t9!\u0003BC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003/I!\u0011!Q\u0001\n\u0005-\u0001BCA\r\u0013\t\u0015\r\u0011\"\u0001\u0002\u001c!Q\u0011\u0011F\u0005\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005-\u0012B!b\u0001\n\u0003\ti\u0003\u0003\u0006\u0002<%\u0011\t\u0011)A\u0005\u0003_Aa!O\u0005\u0005\u0002\u0005ubABA4\u0013\u0001\tI\u0007\u0003\u0004:'\u0011\u0005\u0011Q\u0010\u0004\u0007\u0003\u0007K\u0001!!\"\t\re*B\u0011AAD\u0011%\tY)\u0003b\u0001\n\u0013\ti\t\u0003\u0005\u0002 &\u0001\u000b\u0011BAH\u0011%\t\t+\u0003b\u0001\n\u0013\ti\t\u0003\u0005\u0002$&\u0001\u000b\u0011BAH\u0011\u0019)\u0013\u0002\"\u0011\u0002&\"9\u0011QX\u0005\u0005\u0002\u0005}\u0006bBA_\u0013\u0011\u0005\u0011\u0011 \u0005\b\u0005KIA\u0011\u0001B\u0014\u0011\u001d\u0011Y%\u0003C\u0001\u0005\u001bBqA!\u0019\n\t\u0013\u0011\u0019\u0007C\u0004\u0003r%!IAa\u001d\t\u0013\tu\u0015\"%A\u0005\n\t}\u0015\u0001D+qY>\fGMU8vi\u0016\u001c(BA\u0013'\u0003\u0019\u0011x.\u001e;fg*\u0011q\u0005K\u0001\u0005U6\f\u0007O\u0003\u0002*U\u0005)!.Y7fg*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0001\"\u0001M\u0001\u000e\u0003\u0011\u0012A\"\u00169m_\u0006$'k\\;uKN\u001c\"!A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq&\u0001\u0004M\u001f\u001e;UIU\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tL\u0001\u0006g24GG[\u0005\u0003\u0005~\u0012a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000b\t\u0002\u0005'&TX\r\u0005\u0003G\u001fF#V\"A$\u000b\u0005!K\u0015aA1qS*\u0011!jS\u0001\be\u00164\u0017N\\3e\u0015\taU*A\u0004uS6,\u0007/\u001b;\u000b\u00039\u000b!!Z;\n\u0005A;%a\u0002*fM&tW\r\u001a\t\u0003iIK!aU\u001b\u0003\t1{gn\u001a\t\u0003+\u0006t!AV0\u000f\u0005]sfB\u0001-^\u001d\tIF,D\u0001[\u0015\tYf&\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0011A*T\u0005\u0003\u0015.K!\u0001Y%\u0002\u000f9,X.\u001a:jG&\u0011!m\u0019\u0002\f\u001d>tg*Z4bi&4XM\u0003\u0002a\u0013\u0006!!,\u001a:p+\u00051\u0007CA4\u0006\u001b\u0005\t\u0011!\u0002.fe>\u0004\u0013\u0001D:b]&$\u0018N_3TSj,GC\u00014l\u0011\u0015a\u0007\u00021\u0001R\u0003\u00151\u0018\r\\;f'\rIaN\u001e\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019y%M[3diB\u0011q\u000f_\u0007\u0002M%\u0011\u0011P\n\u0002\u000b\u00156\u000b\u0005KU8vi\u0016\u001c\u0018!D1vi\",g\u000e^5dCR|'/F\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011qPJ\u0001\u0005QR$\b/C\u0002\u0002\u0004y\u0014Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005Ea%\u0001\u0003d_J,\u0017\u0002BA\u000b\u0003\u001f\u0011\u0001DS7baJ37\r\u000f\u001c3c\r{gNZ5hkJ\fG/[8o\u00039\u0019wN\u001c4jOV\u0014\u0018\r^5p]\u0002\n\u0011#\u0019;uC\u000eDW.\u001a8u\u001b\u0006t\u0017mZ3s+\t\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019\u0003K\u0001\b[\u0006LGNY8y\u0013\u0011\t9#!\t\u0003#\u0005#H/Y2i[\u0016tG/T1oC\u001e,'/\u0001\nbiR\f7\r[7f]Rl\u0015M\\1hKJ\u0004\u0013AC:fe&\fG.\u001b>feV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0014\u0002\t)\u001cxN\\\u0005\u0005\u0003s\t\u0019D\u0001\tVa2|\u0017\rZ*fe&\fG.\u001b>fe\u0006Y1/\u001a:jC2L'0\u001a:!))\ty$!\u0011\u0002Z\u0005m\u0013Q\f\t\u0003a%AQA\u001f\nA\u0002qDs!!\u0011\u0002F1\f)\u0006\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\r%t'.Z2u\u0015\t\ty%A\u0003kCZ\f\u00070\u0003\u0003\u0002T\u0005%#!\u0002(b[\u0016$\u0017EAA,\u0003!\u0011fiQ\u00179mI\n\u0004bBA\u0004%\u0001\u0007\u00111\u0002\u0005\b\u00033\u0011\u0002\u0019AA\u000f\u0011\u001d\tYC\u0005a\u0001\u0003_A3AEA1!\u0011\t9%a\u0019\n\t\u0005\u0015\u0014\u0011\n\u0002\u0007\u0013:TWm\u0019;\u00031\r\u000bgnY3mY\u0016$W\u000b\u001d7pC\u0012,\u0005pY3qi&|gnE\u0002\u0014\u0003W\u0002B!!\u001c\u0002x9!\u0011qNA:\u001d\rI\u0016\u0011O\u0005\u0002m%\u0019\u0011QO\u001b\u0002\u000fA\f7m[1hK&!\u0011\u0011PA>\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gNC\u0002\u0002vU\"\"!a \u0011\u0007\u0005\u00055#D\u0001\n\u0005ii\u0015\r\u001f$jY\u0016\u001c\u0016N_3Va2|\u0017\rZ#yG\u0016\u0004H/[8o'\r)\u00121\u000e\u000b\u0003\u0003\u0013\u00032!!!\u0016\u00039\t7mY8v]RLE\rU1sC6,\"!a$\u0011\t\u0005E\u0015\u0011\u0014\b\u0005\u0003'\u000b)\n\u0005\u0002Zk%\u0019\u0011qS\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY*!(\u0003\rM#(/\u001b8h\u0015\r\t9*N\u0001\u0010C\u000e\u001cw.\u001e8u\u0013\u0012\u0004\u0016M]1nA\u0005IQ\u000f\u001d7pC\u0012,&+S\u0001\u000bkBdw.\u00193V%&\u0003CCAAT!\u0019\tI+a-\u000286\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0004tiJ,\u0017-\u001c\u0006\u0004\u0003c\u0013\u0018\u0001B;uS2LA!!.\u0002,\n11\u000b\u001e:fC6\u00042a^A]\u0013\r\tYL\n\u0002\n\u00156\u000b\u0005KU8vi\u0016\fA\u0001]8tiR1\u0011\u0011YAm\u0003_\u0004b!a1\u0002P\u0006MWBAAc\u0015\u0011\t9-!3\u0002\u0013A,(\r\\5tQ\u0016\u0014(\u0002BA\t\u0003\u0017T!!!4\u0002\u000fI,\u0017m\u0019;pe&!\u0011\u0011[Ac\u0005\u0011iuN\\8\u0011\u0007=\f).C\u0002\u0002XB\u0014AAV8jI\"9\u00111\u001c\u000fA\u0002\u0005u\u0017a\u0002:fcV,7\u000f\u001e\t\u0005\u0003?\fY/\u0004\u0002\u0002b*!\u00111]As\u0003\u0019\u0019XM\u001d<fe*\u0019q0a:\u000b\t\u0005%\u00181Z\u0001\u0006]\u0016$H/_\u0005\u0005\u0003[\f\tOA\tIiR\u00048+\u001a:wKJ\u0014V-];fgRDq!!=\u001d\u0001\u0004\t\u00190\u0001\u0005sKN\u0004xN\\:f!\u0011\ty.!>\n\t\u0005]\u0018\u0011\u001d\u0002\u0013\u0011R$\boU3sm\u0016\u0014(+Z:q_:\u001cX\r\u0006\u0006\u0002|\n\u001d!\u0011\u0002B\u0006\u00057\u0001b!!@\u0003\u0004\u0005MWBAA\u0000\u0015\u0011\t9M!\u0001\u000b\u0007Y\nI-\u0003\u0003\u0003\u0006\u0005}(!B*N_:|\u0007bBAn;\u0001\u0007\u0011Q\u001c\u0005\b\u0003cl\u0002\u0019AAz\u0011\u001d\u0011i!\ba\u0001\u0005\u001f\t1bY8oi\u0016tG\u000fV=qKB!!\u0011\u0003B\f\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\u0005\u0005\u0012!B7pI\u0016d\u0017\u0002\u0002B\r\u0005'\u00111bQ8oi\u0016tG\u000fV=qK\"9!QD\u000fA\u0002\t}\u0011aB:fgNLwN\u001c\t\u0005\u0003?\u0011\t#\u0003\u0003\u0003$\u0005\u0005\"AD'bS2\u0014w\u000e_*fgNLwN\\\u0001\u0007Q\u0006tG\r\\3\u0015\u0019\u0005m(\u0011\u0006B\u001a\u0005k\u0011)E!\u0013\t\u000f\t-b\u00041\u0001\u0003.\u0005I\u0011mY2pk:$\u0018\n\u001a\t\u0005\u0003\u001b\u0011y#\u0003\u0003\u00032\u0005=!!C!dG>,h\u000e^%e\u0011\u001d\u0011iA\ba\u0001\u0005\u001fAqAa\u000e\u001f\u0001\u0004\u0011I$A\u0004d_:$XM\u001c;\u0011\t\tm\"\u0011I\u0007\u0003\u0005{Q1Aa\u0010s\u0003\tIw.\u0003\u0003\u0003D\tu\"aC%oaV$8\u000b\u001e:fC6DqAa\u0012\u001f\u0001\u0004\u0011y\"\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\t\u000f\u0005Eh\u00041\u0001\u0002t\u0006iQ\u000f\u001d7pC\u0012\u001cuN\u001c;f]R$\"Ba\u0014\u0003X\te#1\fB0!\u0019\tiPa\u0001\u0003RA\u0019\u0001Ga\u0015\n\u0007\tUCE\u0001\bVa2|\u0017\r\u001a*fgB|gn]3\t\u000f\t-r\u00041\u0001\u0003.!9!QB\u0010A\u0002\t=\u0001b\u0002B/?\u0001\u0007!\u0011H\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0003\u001e}\u0001\rAa\b\u0002\u001d\u0019\u0014x.\\!ui\u0006\u001c\u0007.\\3oiR1!\u0011\u000bB3\u0005_BqAa\u001a!\u0001\u0004\u0011I'\u0001\nbiR\f7\r[7f]RlU\r^1eCR\f\u0007\u0003\u0002B\t\u0005WJAA!\u001c\u0003\u0014\t\u0011\u0012\t\u001e;bG\"lWM\u001c;NKR\fG-\u0019;b\u0011\u001d\u0011Y\u0003\ta\u0001\u0005[\taB]3ta>tG\rR3uC&d7\u000f\u0006\u0005\u0002|\nU$\u0011\u0010BB\u0011\u001d\u00119(\ta\u0001\u0003g\f!\u0003\u001b;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\"9!1P\u0011A\u0002\tu\u0014a\u00023fi\u0006LGn\u001d\t\u0005\u0003\u001b\u0011y(\u0003\u0003\u0003\u0002\u0006=!A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d\u0005\n\u0005\u000b\u000b\u0003\u0013!a\u0001\u0005\u000f\u000b!b\u001d;biV\u001c8i\u001c3f!\u0011\u0011II!'\u000e\u0005\t-%bA@\u0003\u000e*!!q\u0012BI\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\u0011\u0019J!&\u0002\u000f!\fg\u000e\u001a7fe*!\u0011\u0011\u001eBL\u0015\t\u0011y$\u0003\u0003\u0003\u001c\n-%A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukN\f\u0001D]3ta>tG\rR3uC&d7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tK\u000b\u0003\u0003\b\n\r6F\u0001BS!\u0011\u00119K!-\u000e\u0005\t%&\u0002\u0002BV\u0005[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=V'\u0001\u0006b]:|G/\u0019;j_:LAAa-\u0003*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class UploadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final JmapRfc8621Configuration configuration;
    private final AttachmentManager attachmentManager;
    private final UploadSerializer serializer;
    private final String accountIdParam;
    private final String uploadURI;

    public static Long sanitizeSize(long l) {
        return UploadRoutes$.MODULE$.sanitizeSize(l);
    }

    public static Long Zero() {
        return UploadRoutes$.MODULE$.Zero();
    }

    public static Logger LOGGER() {
        return UploadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    public AttachmentManager attachmentManager() {
        return this.attachmentManager;
    }

    public UploadSerializer serializer() {
        return this.serializer;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String uploadURI() {
        return this.uploadURI;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, this.uploadURI())).action((request, response) -> this.post(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.uploadURI())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    public Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        String string2 = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Mono mono = SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)session -> this.post(request, response, ContentType.of((String)string2), (MailboxSession)session)).onErrorResume((Function1 & Serializable)x0$1 -> {
            SMono<Void> sMono;
            Throwable throwable = x0$1;
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                UploadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
                String x$2 = unauthorizedException.getMessage();
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, x$2), HttpResponseStatus.UNAUTHORIZED);
            } else if (throwable instanceof TooBigUploadException) {
                HttpResponseStatus x$5 = HttpResponseStatus.BAD_REQUEST;
                String x$6 = "Attempt to upload exceed max size";
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, "Attempt to upload exceed max size"), HttpResponseStatus.BAD_REQUEST);
            } else if (throwable instanceof ForbiddenException) {
                HttpResponseStatus x$9 = HttpResponseStatus.FORBIDDEN;
                String x$10 = "Upload to other accounts is forbidden";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "Upload to other accounts is forbidden"), HttpResponseStatus.FORBIDDEN);
            } else {
                UploadRoutes$.MODULE$.LOGGER().error("Unexpected error upon uploads", throwable);
                HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                String x$14 = throwable.getMessage();
                String x$15 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            return sMono;
        }).asJava().subscribeOn(Schedulers.elastic()).then();
        return mono;
    }

    public SMono<Void> post(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession session) {
        Left left;
        IllegalArgumentException throwable;
        SMono sMono;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, boolean.And<collection.Size<boolean.And<boolean.Not<numeric.Less<Object>>, boolean.Not<numeric.Greater<Object>>>>, string.MatchesRegex<String>>>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            AccountId targetAccountId = new AccountId(string2);
            sMono = (SMono)AccountId$.MODULE$.from(session.getUser()).map((Function1 & Serializable)accountId -> BoxesRunTime.boxToBoolean((boolean)accountId.equals(targetAccountId))).fold((Function1 & Serializable)e -> SMono$.MODULE$.raiseError((Throwable)e), (Function1 & Serializable)value -> UploadRoutes.$anonfun$post$5(this, request, targetAccountId, contentType, session, response, BoxesRunTime.unboxToBoolean((Object)value)));
        } else if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            sMono = SMono$.MODULE$.raiseError((Throwable)illegalArgumentException);
        } else {
            throw new MatchError(either);
        }
        return sMono;
    }

    public SMono<Void> handle(AccountId accountId, ContentType contentType, InputStream content, MailboxSession mailboxSession, HttpServerResponse response) {
        long maxSize = BoxesRunTime.unboxToLong((Object)this.configuration().maxUploadSize().value());
        return SMono$.MODULE$.fromCallable(() -> new LimitedInputStream(null, content, maxSize){

            public void raiseError(long max, long count) {
                if (count > max) {
                    throw new TooBigUploadException();
                }
            }
        }).flatMap((Function1 & Serializable)x$1 -> this.uploadContent(accountId, contentType, (InputStream)x$1, mailboxSession)).flatMap((Function1 & Serializable)uploadResponse -> SMono$.MODULE$.fromPublisher((Publisher)response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)uploadResponse.type().asString()).status(HttpResponseStatus.CREATED).sendString((Publisher)SMono$.MODULE$.just((Object)this.serializer().serialize((UploadResponse)uploadResponse).toString()))));
    }

    public SMono<UploadResponse> uploadContent(AccountId accountId, ContentType contentType, InputStream inputStream, MailboxSession session) {
        return SMono$.MODULE$.fromPublisher(this.attachmentManager().storeAttachment(contentType, inputStream, session)).map((Function1 & Serializable)x$2 -> this.fromAttachment((AttachmentMetadata)x$2, accountId));
    }

    private UploadResponse fromAttachment(AttachmentMetadata attachmentMetadata, AccountId accountId) {
        BlobId x$1 = (BlobId)BlobId$.MODULE$.of(attachmentMetadata.getAttachmentId().getId()).get();
        ContentType x$2 = ContentType.of((String)attachmentMetadata.getType().asString());
        Long x$3 = UploadRoutes$.MODULE$.sanitizeSize(attachmentMetadata.getSize());
        AccountId x$4 = accountId;
        return new UploadResponse(x$4, x$1, x$2, x$3);
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(statusCode).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ SMono $anonfun$post$5(UploadRoutes $this, HttpServerRequest request$2, AccountId targetAccountId$1, ContentType contentType$1, MailboxSession session$1, HttpServerResponse response$2, boolean value) {
        return value ? SMono$.MODULE$.fromCallable(() -> ReactorUtils.toInputStream((Flux)request$2.receive().asByteArray().map(array -> ByteBuffer.wrap(array)))).flatMap((Function1 & Serializable)content -> $this.handle(targetAccountId$1, contentType$1, (InputStream)content, session$1, response$2)) : SMono$.MODULE$.raiseError((Throwable)new ForbiddenException());
    }

    @Inject
    public UploadRoutes(@Named(value="RFC-8621") Authenticator authenticator, JmapRfc8621Configuration configuration, AttachmentManager attachmentManager, UploadSerializer serializer) {
        this.authenticator = authenticator;
        this.configuration = configuration;
        this.attachmentManager = attachmentManager;
        this.serializer = serializer;
        this.accountIdParam = "accountId";
        this.uploadURI = new StringBuilder(11).append("/upload/{").append(this.accountIdParam()).append("}/").toString();
    }

    public class CancelledUploadException
    extends RuntimeException {
        public /* synthetic */ UploadRoutes org$apache$james$jmap$routes$UploadRoutes$CancelledUploadException$$$outer() {
            return UploadRoutes.this;
        }

        public CancelledUploadException() {
            if (UploadRoutes.this == null) {
                throw null;
            }
        }
    }

    public class MaxFileSizeUploadException
    extends RuntimeException {
        public /* synthetic */ UploadRoutes org$apache$james$jmap$routes$UploadRoutes$MaxFileSizeUploadException$$$outer() {
            return UploadRoutes.this;
        }

        public MaxFileSizeUploadException() {
            if (UploadRoutes.this == null) {
                throw null;
            }
        }
    }
}

