/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.ErrorCode$AccountNotFound$;
import org.apache.james.jmap.core.ErrorCode$CannotCalculateChanges$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.ErrorCode$UnsupportedFilter$;
import org.apache.james.jmap.core.ErrorCode$UnsupportedSort$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Session;
import org.apache.james.jmap.mail.UnsupportedFilterException;
import org.apache.james.jmap.mail.UnsupportedNestingException;
import org.apache.james.jmap.mail.UnsupportedRequestParameterException;
import org.apache.james.jmap.mail.UnsupportedSortException;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.WithAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dca\u0002\u0005\n!\u0003\r\t\u0001\u0006\u0005\u0006A\u0001!\t!\t\u0005\u0006K\u00011\tA\n\u0005\u0006_\u00011\t\u0001\r\u0005\u0006o\u0001!\t\u0005\u000f\u0005\u0006Y\u0002!I!\u001c\u0005\b\u0003'\u0001a\u0011AA\u000b\u0011\u001d\t9\u0004\u0001D\u0001\u0003s\u0011\u0001$T3uQ>$'+Z9vSJLgnZ!dG>,h\u000e^%e\u0015\tQ1\"\u0001\u0004nKRDw\u000e\u001a\u0006\u0003\u00195\tAA[7ba*\u0011abD\u0001\u0006U\u0006lWm\u001d\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007U\t)cE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005I\u0011BA\u0010\n\u0005\u0019iU\r\u001e5pI\u00061A%\u001b8ji\u0012\"\u0012A\t\t\u0003/\rJ!\u0001\n\r\u0003\tUs\u0017\u000e^\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u0003\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002-\u001b\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001\u0018*\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006y1/Z:tS>t7+\u001e9qY&,'/F\u00012!\t\u0011T'D\u00014\u0015\t!4\"\u0001\u0004s_V$Xm]\u0005\u0003mM\u0012qbU3tg&|gnU;qa2LWM]\u0001\baJ|7-Z:t)\u0011I$I\u00193\u0011\u0007ijt(D\u0001<\u0015\ta\u0014#A\bsK\u0006\u001cG/\u001b<fgR\u0014X-Y7t\u0013\tq4HA\u0005Qk\nd\u0017n\u001d5feB\u0011Q\u0004Q\u0005\u0003\u0003&\u0011Q#\u00138w_\u000e\fG/[8o/&$\bnQ8oi\u0016DH\u000fC\u0003D\t\u0001\u0007A)\u0001\u0007dCB\f'-\u001b7ji&,7\u000fE\u0002F\u0019>s!A\u0012&\u0011\u0005\u001dCR\"\u0001%\u000b\u0005%\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002L1\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\u0007M+GO\u0003\u0002L1A\u0011\u0001k\u0018\b\u0003#rs!A\u0015.\u000f\u0005MKfB\u0001+Y\u001d\t)vK\u0004\u0002H-&\t!#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!aW\u0006\u0002\t\r|'/Z\u0005\u0003;z\u000bAcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014(BA.\f\u0013\t\u0001\u0017M\u0001\u000bDCB\f'-\u001b7jifLE-\u001a8uS\u001aLWM\u001d\u0006\u0003;zCQa\u0019\u0003A\u0002}\n!\"\u001b8w_\u000e\fG/[8o\u0011\u0015)G\u00011\u0001g\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004\"a\u001a6\u000e\u0003!T!![\u0007\u0002\u000f5\f\u0017\u000e\u001c2pq&\u00111\u000e\u001b\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0003E1\u0018\r\\5eCR,\u0017iY2pk:$\u0018\n\u001a\u000b\t]z\f9!!\u0003\u0002\fA!q\u000e^<{\u001d\t\u0001(O\u0004\u0002Hc&\t\u0011$\u0003\u0002t1\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005\u0019)\u0015\u000e\u001e5fe*\u00111\u000f\u0007\t\u0003_bL!!\u001f<\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g\u000e\u0005\u0002|y6\ta,\u0003\u0002~=\n91+Z:tS>t\u0007BB@\u0006\u0001\u0004\t\t!A\u0005bG\u000e|WO\u001c;JIB\u001910a\u0001\n\u0007\u0005\u0015aLA\u0005BG\u000e|WO\u001c;JI\")Q-\u0002a\u0001M\")q&\u0002a\u0001c!11-\u0002a\u0001\u0003\u001b\u00012a_A\b\u0013\r\t\tB\u0018\u0002\u000b\u0013:4xnY1uS>t\u0017!\u00033p!J|7-Z:t)%I\u0014qCA\r\u00037\ti\u0002C\u0003D\r\u0001\u0007A\tC\u0003d\r\u0001\u0007q\bC\u0003f\r\u0001\u0007a\rC\u0004\u0002 \u0019\u0001\r!!\t\u0002\u000fI,\u0017/^3tiB!\u00111EA\u0013\u0019\u0001!q!a\n\u0001\u0005\u0004\tICA\u0004S\u000bF+Vi\u0015+\u0012\t\u0005-\u0012\u0011\u0007\t\u0004/\u00055\u0012bAA\u00181\t9aj\u001c;iS:<\u0007cA\u000f\u00024%\u0019\u0011QG\u0005\u0003\u001b]KG\u000f[!dG>,h\u000e^%e\u0003)9W\r\u001e*fcV,7\u000f\u001e\u000b\u0007\u0003w\t\u0019%!\u0012\u0011\r=$\u0018QHA\u0011!\ry\u0017qH\u0005\u0004\u0003\u00032(!C#yG\u0016\u0004H/[8o\u0011\u0015)w\u00011\u0001g\u0011\u0019\u0019w\u00011\u0001\u0002\u000e\u0001")
public interface MethodRequiringAccountId<REQUEST extends WithAccountId>
extends Method {
    public MetricFactory metricFactory();

    public SessionSupplier sessionSupplier();

    public static /* synthetic */ Publisher process$(MethodRequiringAccountId $this, Set capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return $this.process((Set<Refined<String, string.Uri>>)capabilities, invocation, mailboxSession);
    }

    @Override
    default public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        Either either = this.getRequest(mailboxSession, invocation.invocation()).flatMap((Function1 & Serializable)request -> this.validateAccountId(request.accountId(), mailboxSession, this.sessionSupplier(), invocation.invocation()).map((Function1 & Serializable)x$1 -> {
            Session session = x$1;
            Publisher<InvocationWithContext> publisher = this.doProcess(capabilities, invocation, mailboxSession, request);
            return publisher;
        }));
        SFlux result = SFlux$.MODULE$.fromPublisher((Publisher)either.fold((Function1 & Serializable)e -> SFlux$.MODULE$.raiseError((Throwable)e, SFlux$.MODULE$.raiseError$default$2()), (Function1 & Serializable)r -> r)).onErrorResume((Function1 & Serializable)x0$1 -> {
            SFlux sFlux;
            Throwable throwable = x0$1;
            if (throwable instanceof AccountNotFoundException) {
                AccountNotFoundException accountNotFoundException = (AccountNotFoundException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(accountNotFoundException.invocation(), invocation.processingContext())}));
            } else if (throwable instanceof UnsupportedRequestParameterException) {
                UnsupportedRequestParameterException unsupportedRequestParameterException = (UnsupportedRequestParameterException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, new StringBuilder(84).append("The following parameter ").append(unsupportedRequestParameterException.unsupportedParam()).append(" is syntactically valid, but is not supported by the server.").toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable instanceof UnsupportedSortException) {
                UnsupportedSortException unsupportedSortException = (UnsupportedSortException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnsupportedSort$.MODULE$, new StringBuilder(144).append("The sort ").append(unsupportedSortException.unsupportedSort()).append(" is syntactically valid, but it includes a property the server does not support sorting on or a collation method it does not recognise.").toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable instanceof UnsupportedFilterException) {
                UnsupportedFilterException unsupportedFilterException = (UnsupportedFilterException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnsupportedFilter$.MODULE$, new StringBuilder(187).append("The filter ").append(unsupportedFilterException.unsupportedFilter()).append(" is syntactically valid, but the server cannot process it. If the filter was the result of a user\u2019s search input, the client SHOULD suggest that the user simplify their search.").toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable instanceof UnsupportedNestingException) {
                UnsupportedNestingException unsupportedNestingException = (UnsupportedNestingException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnsupportedFilter$.MODULE$, unsupportedNestingException.message(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, mailboxNotFoundException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable instanceof ChangeNotFoundException) {
                ChangeNotFoundException changeNotFoundException = (ChangeNotFoundException)throwable;
                sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$CannotCalculateChanges$.MODULE$, changeNotFoundException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                sFlux = SFlux$.MODULE$.raiseError(throwable2, SFlux$.MODULE$.raiseError$default$2());
            } else {
                throw new MatchError((Object)throwable);
            }
            return sFlux;
        });
        return this.metricFactory().decoratePublisherWithTimerMetricLogP99(new StringBuilder(0).append(this.JMAP_RFC8621_PREFIX()).append(new Refined((Object)this.methodName().value())).toString(), (Publisher)result);
    }

    private Either<IllegalArgumentException, Session> validateAccountId(AccountId accountId, MailboxSession mailboxSession, SessionSupplier sessionSupplier, Invocation invocation) {
        return sessionSupplier.generate(mailboxSession.getUser()).flatMap((Function1 & Serializable)session -> session.accounts().map((Function1 & Serializable)x$2 -> x$2.accountId()).contains((Object)accountId) ? package$.MODULE$.Right().apply(session) : package$.MODULE$.Left().apply((Object)new AccountNotFoundException(Invocation$.MODULE$.error(ErrorCode$AccountNotFound$.MODULE$, invocation.methodCallId()))));
    }

    public Publisher<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> var1, InvocationWithContext var2, MailboxSession var3, REQUEST var4);

    public Either<Exception, REQUEST> getRequest(MailboxSession var1, Invocation var2);

    public static void $init$(MethodRequiringAccountId $this) {
    }
}

