/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableList;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.EmailSet$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.mail.ValidatedEmailSetUpdate;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$EmailUpdateSuccess$;
import org.apache.james.jmap.method.MessageNotFoundException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011Ut!B/_\u0011\u0003Ig!B6_\u0011\u0003a\u0007\"B:\u0002\t\u0003!haB;\u0002!\u0003\r\nA\u001e\u0004\u0005o\u0006\u0001\u0005\u0010\u0003\u0006\u0002\u0016\u0011\u0011)\u001a!C\u0001\u0003/A!\"!\u000b\u0005\u0005#\u0005\u000b\u0011BA\r\u0011\u0019\u0019H\u0001\"\u0001\u0002,!I\u0011\u0011\u0007\u0003\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003o!\u0011\u0013!C\u0001\u0003sA\u0011\"a\u0014\u0005\u0003\u0003%\t%!\u0015\t\u0013\u0005\rD!!A\u0005\u0002\u0005\u0015\u0004\"CA7\t\u0005\u0005I\u0011AA8\u0011%\tY\bBA\u0001\n\u0003\ni\bC\u0005\u0002\f\u0012\t\t\u0011\"\u0001\u0002\u000e\"I\u0011q\u0013\u0003\u0002\u0002\u0013\u0005\u0013\u0011\u0014\u0005\n\u0003;#\u0011\u0011!C!\u0003?C\u0011\"!)\u0005\u0003\u0003%\t%a)\t\u0013\u0005\u0015F!!A\u0005B\u0005\u001dv!CAV\u0003\u0005\u0005\t\u0012AAW\r!9\u0018!!A\t\u0002\u0005=\u0006BB:\u0015\t\u0003\t9\rC\u0005\u0002\"R\t\t\u0011\"\u0012\u0002$\"I\u0011\u0011\u001a\u000b\u0002\u0002\u0013\u0005\u00151\u001a\u0005\n\u0003\u001f$\u0012\u0011!CA\u0003#D\u0011\"!8\u0015\u0003\u0003%I!a8\u0007\r\u0005\u001d\u0018\u0001QAu\u0011)\tYO\u0007BK\u0002\u0013\u0005\u0011Q\u001e\u0005\u000b\u0005+Q\"\u0011#Q\u0001\n\u0005=\bB\u0003B\f5\tU\r\u0011\"\u0001\u0003\u001a!Q!\u0011\u0005\u000e\u0003\u0012\u0003\u0006IAa\u0007\t\rMTB\u0011\u0001B\u0012\u0011\u001d\u0011YC\u0007C\u0001\u0005[A\u0011\"!\r\u001b\u0003\u0003%\tAa\u000f\t\u0013\u0005]\"$%A\u0005\u0002\t\u0005\u0003\"\u0003B#5E\u0005I\u0011\u0001B$\u0011%\tyEGA\u0001\n\u0003\n\t\u0006C\u0005\u0002di\t\t\u0011\"\u0001\u0002f!I\u0011Q\u000e\u000e\u0002\u0002\u0013\u0005!1\n\u0005\n\u0003wR\u0012\u0011!C!\u0003{B\u0011\"a#\u001b\u0003\u0003%\tAa\u0014\t\u0013\u0005]%$!A\u0005B\tM\u0003\"CAO5\u0005\u0005I\u0011IAP\u0011%\t\tKGA\u0001\n\u0003\n\u0019\u000bC\u0005\u0002&j\t\t\u0011\"\u0011\u0003X\u001dI!1L\u0001\u0002\u0002#\u0005!Q\f\u0004\n\u0003O\f\u0011\u0011!E\u0001\u0005?Baa\u001d\u0018\u0005\u0002\t\u001d\u0004\"CAQ]\u0005\u0005IQIAR\u0011%\tIMLA\u0001\n\u0003\u0013I\u0007C\u0005\u0002P:\n\t\u0011\"!\u0003p!I\u0011Q\u001c\u0018\u0002\u0002\u0013%\u0011q\u001c\u0004\u0007\u0005w\n\u0001I! \t\u0015\t}DG!f\u0001\n\u0003\u0011\t\t\u0003\u0006\u0003\nR\u0012\t\u0012)A\u0005\u0005\u0007Caa\u001d\u001b\u0005\u0002\t-\u0005b\u0002BIi\u0011\u0005!1\u0013\u0005\b\u0005[#D\u0011\u0001BX\u0011%\t\t\u0004NA\u0001\n\u0003\u0011)\fC\u0005\u00028Q\n\n\u0011\"\u0001\u0003:\"I\u0011q\n\u001b\u0002\u0002\u0013\u0005\u0013\u0011\u000b\u0005\n\u0003G\"\u0014\u0011!C\u0001\u0003KB\u0011\"!\u001c5\u0003\u0003%\tA!0\t\u0013\u0005mD'!A\u0005B\u0005u\u0004\"CAFi\u0005\u0005I\u0011\u0001Ba\u0011%\t9\nNA\u0001\n\u0003\u0012)\rC\u0005\u0002\u001eR\n\t\u0011\"\u0011\u0002 \"I\u0011\u0011\u0015\u001b\u0002\u0002\u0013\u0005\u00131\u0015\u0005\n\u0003K#\u0014\u0011!C!\u0005\u0013<\u0011B!4\u0002\u0003\u0003E\tAa4\u0007\u0013\tm\u0014!!A\t\u0002\tE\u0007BB:G\t\u0003\u0011)\u000eC\u0005\u0002\"\u001a\u000b\t\u0011\"\u0012\u0002$\"I\u0011\u0011\u001a$\u0002\u0002\u0013\u0005%q\u001b\u0005\n\u0003\u001f4\u0015\u0011!CA\u00057D\u0011\"!8G\u0003\u0003%I!a8\u0007\u000b-t\u0006A!9\t\u0015\t\rHJ!A!\u0002\u0013\u0011)\u000f\u0003\u0006\u0003r2\u0013\t\u0011)A\u0005\u0005gD!Ba?M\u0005\u0003\u0005\u000b\u0011\u0002B\u007f\u0011)\u0019\u0019\u0001\u0014B\u0001B\u0003%1Q\u0001\u0005\u0007g2#\taa\u0005\t\u000f\rEB\n\"\u0001\u00044!91\u0011\u0007'\u0005\n\r\u001d\u0004bBBE\u0019\u0012%11\u0012\u0005\b\u0007scE\u0011BB^\u0011\u001d\u0019y\r\u0014C\u0005\u0007#Dq\u0001b\u0003M\t\u0013!i\u0001C\u0004\u0005\u001a1#I\u0001b\u0007\t\u000f\u0011UB\n\"\u0003\u00058!9Aq\b'\u0005\n\u0011\u0005\u0003b\u0002C)\u0019\u0012%A1\u000b\u0005\b\tKbE\u0011\u0002C4\u0003])U.Y5m'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002`A\u00061Q.\u001a;i_\u0012T!!\u00192\u0002\t)l\u0017\r\u001d\u0006\u0003G\u0012\fQA[1nKNT!!\u001a4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0017aA8sO\u000e\u0001\u0001C\u00016\u0002\u001b\u0005q&aF#nC&d7+\u001a;Va\u0012\fG/\u001a)fe\u001a|'/\\3s'\t\tQ\u000e\u0005\u0002oc6\tqNC\u0001q\u0003\u0015\u00198-\u00197b\u0013\t\u0011xN\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0014\u0011#R7bS2,\u0006\u000fZ1uKJ+7/\u001e7u'\t\u0019QN\u0001\nF[\u0006LG.\u00169eCR,7+^2dKN\u001c8#\u0002\u0003nsnt\bC\u0001>\u0004\u001b\u0005\t\u0001C\u00018}\u0013\tixNA\u0004Qe>$Wo\u0019;\u0011\u0007}\fyA\u0004\u0003\u0002\u0002\u0005-a\u0002BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001.\u0001\u0004=e>|GOP\u0005\u0002a&\u0019\u0011QB8\u0002\u000fA\f7m[1hK&!\u0011\u0011CA\n\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tia\\\u0001\n[\u0016\u001c8/Y4f\u0013\u0012,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005)Qn\u001c3fY*\u0019\u00111\u00052\u0002\u000f5\f\u0017\u000e\u001c2pq&!\u0011qEA\u000f\u0005%iUm]:bO\u0016LE-\u0001\u0006nKN\u001c\u0018mZ3JI\u0002\"B!!\f\u00020A\u0011!\u0010\u0002\u0005\b\u0003+9\u0001\u0019AA\r\u0003\u0011\u0019w\u000e]=\u0015\t\u00055\u0012Q\u0007\u0005\n\u0003+A\u0001\u0013!a\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002<)\"\u0011\u0011DA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%_\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00027b]\u001eT!!!\u0018\u0002\t)\fg/Y\u0005\u0005\u0003C\n9F\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00022A\\A5\u0013\r\tYg\u001c\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\n9\bE\u0002o\u0003gJ1!!\u001ep\u0005\r\te.\u001f\u0005\n\u0003sb\u0011\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA@!\u0019\t\t)a\"\u0002r5\u0011\u00111\u0011\u0006\u0004\u0003\u000b{\u0017AC2pY2,7\r^5p]&!\u0011\u0011RAB\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0015Q\u0013\t\u0004]\u0006E\u0015bAAJ_\n9!i\\8mK\u0006t\u0007\"CA=\u001d\u0005\u0005\t\u0019AA9\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u00131\u0014\u0005\n\u0003sz\u0011\u0011!a\u0001\u0003O\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\na!Z9vC2\u001cH\u0003BAH\u0003SC\u0011\"!\u001f\u0013\u0003\u0003\u0005\r!!\u001d\u0002%\u0015k\u0017-\u001b7Va\u0012\fG/Z*vG\u000e,7o\u001d\t\u0003uR\u0019R\u0001FAY\u0003{\u0003\u0002\"a-\u0002:\u0006e\u0011QF\u0007\u0003\u0003kS1!a.p\u0003\u001d\u0011XO\u001c;j[\u0016LA!a/\u00026\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002\\\u0005\u0011\u0011n\\\u0005\u0005\u0003#\t\t\r\u0006\u0002\u0002.\u0006)\u0011\r\u001d9msR!\u0011QFAg\u0011\u001d\t)b\u0006a\u0001\u00033\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002T\u0006e\u0007#\u00028\u0002V\u0006e\u0011bAAl_\n1q\n\u001d;j_:D\u0011\"a7\u0019\u0003\u0003\u0005\r!!\f\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002bB!\u0011QKAr\u0013\u0011\t)/a\u0016\u0003\r=\u0013'.Z2u\u0005I)U.Y5m+B$\u0017\r^3GC&dWO]3\u0014\u000bii\u0017p\u001f@\u0002#Ut\u0007/\u0019:tK\u0012lUm]:bO\u0016LE-\u0006\u0002\u0002pB!\u0011\u0011\u001fB\b\u001d\u0011\t\u0019P!\u0003\u000f\t\u0005U(Q\u0001\b\u0005\u0003o\u0014\u0019A\u0004\u0003\u0002z\n\u0005a\u0002BA~\u0003\u007ftA!a\u0001\u0002~&\tq-\u0003\u0002fM&\u00111\rZ\u0005\u0003C\nL1Aa\u0002a\u0003\u0011i\u0017-\u001b7\n\t\t-!QB\u0001\t\u000b6\f\u0017\u000e\\*fi*\u0019!q\u00011\n\t\tE!1\u0003\u0002\u0012+:\u0004\u0018M]:fI6+7o]1hK&#'\u0002\u0002B\u0006\u0005\u001b\t!#\u001e8qCJ\u001cX\rZ'fgN\fw-Z%eA\u0005\tQ-\u0006\u0002\u0003\u001cA\u0019qP!\b\n\t\t}\u00111\u0003\u0002\n)\"\u0014xn^1cY\u0016\f!!\u001a\u0011\u0015\r\t\u0015\"q\u0005B\u0015!\tQ(\u0004C\u0004\u0002l~\u0001\r!a<\t\u000f\t]q\u00041\u0001\u0003\u001c\u0005\t\u0012m]'fgN\fw-Z*fi\u0016\u0013(o\u001c:\u0016\u0005\t=\u0002\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\u0007\tU\u0002-\u0001\u0003d_J,\u0017\u0002\u0002B\u001d\u0005g\u0011\u0001bU3u\u000bJ\u0014xN\u001d\u000b\u0007\u0005K\u0011iDa\u0010\t\u0013\u0005-\u0018\u0005%AA\u0002\u0005=\b\"\u0003B\fCA\u0005\t\u0019\u0001B\u000e+\t\u0011\u0019E\u000b\u0003\u0002p\u0006u\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0013RCAa\u0007\u0002>Q!\u0011\u0011\u000fB'\u0011%\tIHJA\u0001\u0002\u0004\t9\u0007\u0006\u0003\u0002\u0010\nE\u0003\"CA=Q\u0005\u0005\t\u0019AA9)\u0011\t\u0019F!\u0016\t\u0013\u0005e\u0014&!AA\u0002\u0005\u001dD\u0003BAH\u00053B\u0011\"!\u001f-\u0003\u0003\u0005\r!!\u001d\u0002%\u0015k\u0017-\u001b7Va\u0012\fG/\u001a$bS2,(/\u001a\t\u0003u:\u001aRA\fB1\u0003{\u0003\"\"a-\u0003d\u0005=(1\u0004B\u0013\u0013\u0011\u0011)'!.\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003^Q1!Q\u0005B6\u0005[Bq!a;2\u0001\u0004\ty\u000fC\u0004\u0003\u0018E\u0002\rAa\u0007\u0015\t\tE$\u0011\u0010\t\u0006]\u0006U'1\u000f\t\b]\nU\u0014q\u001eB\u000e\u0013\r\u00119h\u001c\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005m''!AA\u0002\t\u0015\"AE#nC&dW\u000b\u001d3bi\u0016\u0014Vm];miN\u001cB\u0001N7|}\u00069!/Z:vYR\u001cXC\u0001BB!\u0011y(QQ=\n\t\t\u001d\u00151\u0003\u0002\u0004'\u0016\f\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\t5%q\u0012\t\u0003uRBqAa 8\u0001\u0004\u0011\u0019)A\u0004va\u0012\fG/\u001a3\u0016\u0005\tU\u0005#\u00028\u0002V\n]\u0005\u0003\u0003BM\u0005C\u000bIBa*\u000f\t\tm%Q\u0014\t\u0004\u0003\u0007y\u0017b\u0001BP_\u00061\u0001K]3eK\u001aLAAa)\u0003&\n\u0019Q*\u00199\u000b\u0007\t}u\u000eE\u0002o\u0005SK1Aa+p\u0005\u0011)f.\u001b;\u0002\u00159|G/\u00169eCR,G-\u0006\u0002\u00032B)a.!6\u00034BA!\u0011\u0014BQ\u0003_\u0014y\u0003\u0006\u0003\u0003\u000e\n]\u0006\"\u0003B@uA\u0005\t\u0019\u0001BB+\t\u0011YL\u000b\u0003\u0003\u0004\u0006uB\u0003BA9\u0005\u007fC\u0011\"!\u001f?\u0003\u0003\u0005\r!a\u001a\u0015\t\u0005=%1\u0019\u0005\n\u0003s\u0002\u0015\u0011!a\u0001\u0003c\"B!a\u0015\u0003H\"I\u0011\u0011P!\u0002\u0002\u0003\u0007\u0011q\r\u000b\u0005\u0003\u001f\u0013Y\rC\u0005\u0002z\u0011\u000b\t\u00111\u0001\u0002r\u0005\u0011R)\\1jYV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;t!\tQhiE\u0003G\u0005'\fi\f\u0005\u0005\u00024\u0006e&1\u0011BG)\t\u0011y\r\u0006\u0003\u0003\u000e\ne\u0007b\u0002B@\u0013\u0002\u0007!1\u0011\u000b\u0005\u0005;\u0014y\u000eE\u0003o\u0003+\u0014\u0019\tC\u0005\u0002\\*\u000b\t\u00111\u0001\u0003\u000eN\u0011A*\\\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002Bt\u0005[l!A!;\u000b\u0007\t-\b-\u0001\u0003kg>t\u0017\u0002\u0002Bx\u0005S\u0014!#R7bS2\u001cV\r^*fe&\fG.\u001b>fe\u0006\u0001R.Z:tC\u001e,\u0017\nZ'b]\u0006<WM\u001d\t\u0005\u0005k\u001490\u0004\u0002\u0002\"%!!\u0011`A\u0011\u0005AiUm]:bO\u0016LE-T1oC\u001e,'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\tU(q`\u0005\u0005\u0007\u0003\t\tC\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002!5,7o]1hK&#g)Y2u_JL\b\u0003BB\u0004\u0007\u001bqA!a\u0007\u0004\n%!11BA\u000f\u0003%iUm]:bO\u0016LE-\u0003\u0003\u0004\u0010\rE!a\u0002$bGR|'/\u001f\u0006\u0005\u0007\u0017\ti\u0002\u0006\u0006\u0004\u0016\r]1\u0011DB\u000e\u0007;\u0001\"A\u001b'\t\u000f\t\r\u0018\u000b1\u0001\u0003f\"9!\u0011_)A\u0002\tM\bb\u0002B~#\u0002\u0007!Q \u0005\b\u0007\u0007\t\u0006\u0019AB\u0003Q\r\t6\u0011\u0005\t\u0005\u0007G\u0019i#\u0004\u0002\u0004&)!1qEB\u0015\u0003\u0019IgN[3di*\u001111F\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0007_\u0019)C\u0001\u0004J]*,7\r^\u0001\u0007kB$\u0017\r^3\u0015\r\rU2\u0011KB/!\u0019\u00199d!\u0012\u0004J5\u00111\u0011\b\u0006\u0005\u0007w\u0019i$A\u0005qk\nd\u0017n\u001d5fe*\u0019\u0001oa\u0010\u000b\t\tU2\u0011\t\u0006\u0003\u0007\u0007\nqA]3bGR|'/\u0003\u0003\u0004H\re\"!B*N_:|\u0007cAB&i9\u00191Q\n\u0001\u000f\t\u0005U8qJ\u0005\u0003?\u0002Dqaa\u0015S\u0001\u0004\u0019)&A\bf[\u0006LGnU3u%\u0016\fX/Z:u!\u0011\u00199f!\u0017\u000e\u0005\t5\u0011\u0002BB.\u0005\u001b\u0011q\"R7bS2\u001cV\r\u001e*fcV,7\u000f\u001e\u0005\b\u0007?\u0012\u0006\u0019AB1\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004BA!>\u0004d%!1QMA\u0011\u00059i\u0015-\u001b7c_b\u001cVm]:j_:$ba!\u000e\u0004j\r\u0015\u0005bBB6'\u0002\u00071QN\u0001\bkB$\u0017\r^3t!!\u0011IJ!)\u0002p\u000e=\u0004\u0003BB9\u0007\u0003k!aa\u001d\u000b\t\t-8Q\u000f\u0006\u0005\u0007o\u001aI(\u0001\u0003mS\n\u001c(\u0002BB>\u0007{\n1!\u00199j\u0015\t\u0019y(\u0001\u0003qY\u0006L\u0018\u0002BBB\u0007g\u0012\u0001BS:PE*,7\r\u001e\u0005\b\u0007\u000f\u001b\u0006\u0019AB1\u0003\u001d\u0019Xm]:j_:\f\u0001\u0002Z8Va\u0012\fG/\u001a\u000b\t\u0007\u001b\u001b\u0019j!*\u00048B11qGB#\u0007\u001f\u0003Ra BC\u0007#\u00032aa\u0013\u0004\u0011\u001d\u0019)\n\u0016a\u0001\u0007/\u000bAB^1mS\u0012,\u0006\u000fZ1uKN\u0004Ra`BM\u0007;KAaa'\u0002\u0014\t!A*[:u!\u001dq'QOA\r\u0007?\u0003Baa\u0016\u0004\"&!11\u0015B\u0007\u0005]1\u0016\r\\5eCR,G-R7bS2\u001cV\r^+qI\u0006$X\rC\u0004\u0004(R\u0003\ra!+\u0002\u00115,G/\u0019#bi\u0006\u0004\u0002B!'\u0003\"\u0006e11\u0016\t\u0006\u007f\u000e56\u0011W\u0005\u0005\u0007_\u000b\u0019BA\u0006Ue\u00064XM]:bE2,\u0007\u0003BA\u000e\u0007gKAa!.\u0002\u001e\ti2i\\7q_N,G-T3tg\u0006<W-\u00133XSRDW*\u001a;b\t\u0006$\u0018\rC\u0004\u0004\bR\u0003\ra!\u0019\u0002\u0011\u0005\u001c(+\u00198hKN$Ba!0\u0004NB11qXBc\u0007\u000fl!a!1\u000b\t\r\r\u00171Q\u0001\nS6lW\u000f^1cY\u0016LAaa'\u0004BB!\u00111DBe\u0013\u0011\u0019Y-!\b\u0003\u00195+7o]1hKJ\u000bgnZ3\t\u000f\r\u001dV\u000b1\u0001\u0004*\u0006\u0011R\u000f\u001d3bi\u00164E.Y4t\u0005f\u0014\u0016M\\4f)9\u0019iia5\u0004^\u000e-8\u0011_Bz\t\u0013Aqa!6W\u0001\u0004\u00199.A\u0005nC&d'm\u001c=JIB!\u00111DBm\u0013\u0011\u0019Y.!\b\u0003\u00135\u000b\u0017\u000e\u001c2pq&#\u0007bBBp-\u0002\u00071\u0011]\u0001\u0006M2\fwm\u001d\t\u0005\u0007G\u001c9/\u0004\u0002\u0004f*!!qAB\u0015\u0013\u0011\u0019Io!:\u0003\u000b\u0019c\u0017mZ:\t\u000f\r5h\u000b1\u0001\u0004p\u00061!/\u00198hKN\u0004Ra`BM\u0007\u000fDqaa*W\u0001\u0004\u0019I\u000bC\u0004\u0004vZ\u0003\raa>\u0002\u0015U\u0004H-\u0019;f\u001b>$W\r\u0005\u0003\u0004z\u0012\ra\u0002BB~\u0007\u007ftA!a>\u0004~&\u0019\u00111\u00052\n\t\u0011\u0005\u0011\u0011E\u0001\u000f\u001b\u0016\u001c8/Y4f\u001b\u0006t\u0017mZ3s\u0013\u0011!)\u0001b\u0002\u0003\u001f\u0019c\u0017mZ:Va\u0012\fG/Z'pI\u0016TA\u0001\"\u0001\u0002\"!91q\u0011,A\u0002\r\u0005\u0014aC7pm\u0016\u0014\u0015PU1oO\u0016$Bb!$\u0005\u0010\u0011EA1\u0003C\u000b\t/Aqa!6X\u0001\u0004\u00199\u000eC\u0004\u00042]\u0003\raa(\t\u000f\r5x\u000b1\u0001\u0004p\"91qU,A\u0002\r%\u0006bBBD/\u0002\u00071\u0011M\u0001\u000ekB$\u0017\r^3CsJ\u000bgnZ3\u0015\u0011\r5EQ\u0004C\u0010\tCAqa!<Y\u0001\u0004\u0019y\u000fC\u0004\u0004(b\u0003\ra!+\t\u000f\u0011\r\u0002\f1\u0001\u0005&\u0005Iq\u000e]3sCRLwN\u001c\t\u0007\tO!\tda2\u000e\u0005\u0011%\"\u0002\u0002C\u0016\t[\t\u0001BZ;oGRLwN\u001c\u0006\u0005\t_\tY&\u0001\u0003vi&d\u0017\u0002\u0002C\u001a\tS\u0011\u0001bQ8ogVlWM]\u0001\u0012kB$\u0017\r^3FC\u000eDW*Z:tC\u001e,G\u0003CBG\ts!Y\u0004\"\u0010\t\u000f\rU\u0015\f1\u0001\u0004\u0018\"91qU-A\u0002\r%\u0006bBBD3\u0002\u00071\u0011M\u0001\u0014kB$\u0017\r^3TS:<G.Z'fgN\fw-\u001a\u000b\u000b\t\u0007\")\u0005b\u0012\u0005J\u0011=\u0003CBB\u001c\u0007\u000b\u001a\t\nC\u0004\u0002\u0016i\u0003\r!!\u0007\t\u000f\rE\"\f1\u0001\u0004 \"9A1\n.A\u0002\u00115\u0013AD:u_J,G-T3uC\u0012\u000bG/\u0019\t\u0006\u007f\u000ee5\u0011\u0017\u0005\b\u0007\u000fS\u0006\u0019AB1\u0003A)\b\u000fZ1uK6\u000b\u0017\u000e\u001c2pq&#7\u000f\u0006\u0006\u0005D\u0011UCq\u000bC-\tGBq!!\u0006\\\u0001\u0004\tI\u0002C\u0004\u00042m\u0003\raa(\t\u000f\u0011m3\f1\u0001\u0005^\u0005QQ.Y5mE>D\u0018\nZ:\u0011\t\r]CqL\u0005\u0005\tC\u0012iA\u0001\u0006NC&d'm\u001c=JINDqaa\"\\\u0001\u0004\u0019\t'A\u0006va\u0012\fG/\u001a$mC\u001e\u001cH\u0003\u0004C\"\tS\"Y\u0007\"\u001c\u0005p\u0011M\u0004bBA\u000b9\u0002\u0007\u0011\u0011\u0004\u0005\b\u0007ca\u0006\u0019ABP\u0011\u001d!Y\u0006\u0018a\u0001\t;Bq\u0001\"\u001d]\u0001\u0004\u0019\t/A\u0007pe&<\u0017N\\1m\r2\fwm\u001d\u0005\b\u0007\u000fc\u0006\u0019AB1\u0001")
public class EmailSetUpdatePerformer {
    private final EmailSetSerializer serializer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;

    public SMono<EmailUpdateResults> update(EmailSetRequest emailSetRequest, MailboxSession mailboxSession) {
        return (SMono)emailSetRequest.update().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).map((Function1 & Serializable)x$4 -> this.update((Map<Refined<String, boolean.Not<collection.Empty>>, JsObject>)x$4, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))));
    }

    private SMono<EmailUpdateResults> update(Map<Refined<String, boolean.Not<collection.Empty>>, JsObject> updates2, MailboxSession session) {
        List validatedUpdates = ((IterableOnceOps)updates2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String unparsedMessageId = (String)((Refined)tuple2._1()).value();
            JsObject json = (JsObject)tuple2._2();
            Either either = EmailSet$.MODULE$.parse($this.messageIdFactory, unparsedMessageId).toEither().left().map((Function1 & Serializable)e -> new EmailUpdateFailure(unparsedMessageId, (Throwable)e)).flatMap((Function1 & Serializable)id -> (Either)$this.serializer.deserializeEmailSetUpdate((JsValue)json).asEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.toString())).flatMap((Function1 & Serializable)x$5 -> x$5.validate()).fold((Function1 & Serializable)e -> package$.MODULE$.Left().apply((Object)new EmailUpdateFailure(unparsedMessageId, (Throwable)e)), (Function1 & Serializable)emailSetUpdate -> package$.MODULE$.Right().apply((Object)new Tuple2(id, emailSetUpdate))));
            return either;
        })).toList();
        List failures = validatedUpdates.flatMap((Function1 & Serializable)x0$2 -> {
            None$ none$;
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                EmailUpdateFailure e = (EmailUpdateFailure)left.value();
                none$ = new Some((Object)e);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        List validUpdates = validatedUpdates.flatMap((Function1 & Serializable)x0$3 -> {
            None$ none$;
            Either either = x0$3;
            if (either instanceof Right) {
                Right right = (Right)either;
                Tuple2 pair = (Tuple2)right.value();
                none$ = new Some((Object)pair);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.messagesMetadata(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)validUpdates.map((Function1 & Serializable)x$6 -> (MessageId)x$6._1())).asJavaCollection(), session)).collectMultimap((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMessageId()).flatMap((Function1 & Serializable)x$7 -> this.doUpdate((List<Tuple2<MessageId, ValidatedEmailSetUpdate>>)validUpdates, (Map<MessageId, Iterable<ComposedMessageIdWithMetaData>>)x$7, session)).map((Function1 & Serializable)updates -> new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)updates.$plus$plus((IterableOnce)failures))));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> doUpdate(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        SMono<scala.collection.immutable.Seq<EmailUpdateResult>> sMono;
        boolean singleMailbox;
        boolean sameUpdate = ((SeqOps)validUpdates.map((Function1 & Serializable)x$8 -> (ValidatedEmailSetUpdate)x$8._2()).distinctBy((Function1 & Serializable)x$9 -> x$9.update())).size() == 1;
        boolean bl = singleMailbox = ((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$10 -> x$10.getComposedMessageId().getMailboxId())).toSet().size() == 1;
        if (sameUpdate && singleMailbox && validUpdates.size() > 3) {
            ValidatedEmailSetUpdate update = (ValidatedEmailSetUpdate)validUpdates.map((Function1 & Serializable)x$11 -> (ValidatedEmailSetUpdate)x$11._2()).headOption().get();
            List<MessageRange> ranges = this.asRanges(metaData);
            MailboxId mailboxId = (MailboxId)((IterableOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$12 -> x$12.getComposedMessageId().getMailboxId())).headOption().get();
            sMono = update.update().isOnlyFlagAddition() ? this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToAdd().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.ADD, session) : (update.update().isOnlyFlagRemoval() ? this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToRemove().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.REMOVE, session) : (update.update().isOnlyMove() ? this.moveByRange(mailboxId, update, ranges, metaData, session) : this.updateEachMessage(validUpdates, metaData, session)));
        } else {
            sMono = this.updateEachMessage(validUpdates, metaData, session);
        }
        return sMono;
    }

    private List<MessageRange> asRanges(Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData) {
        return CollectionConverters$.MODULE$.ListHasAsScala(MessageRange.toRanges((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$13 -> x$13.getComposedMessageId().getUid())).toList().distinct()).asJava())).asScala().toList();
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateFlagsByRange(MailboxId mailboxId, Flags flags, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MessageManager.FlagsUpdateMode updateMode, MailboxSession session) {
        SMono mailboxMono = SMono$.MODULE$.fromCallable(() -> $this.mailboxManager.getMailbox(mailboxId, session));
        return mailboxMono.flatMap((Function1 & Serializable)mailbox -> this.updateByRange(ranges, metaData, range -> mailbox.setFlags(flags, updateMode, range, session))).subscribeOn(Schedulers.elastic());
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> moveByRange(MailboxId mailboxId, ValidatedEmailSetUpdate update, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        MailboxId targetId = (MailboxId)((MailboxIds)update.update().mailboxIds().get()).value().headOption().get();
        return this.updateByRange(ranges, metaData, range -> $this.mailboxManager.moveMessages(range, mailboxId, targetId, session));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateByRange(List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, Consumer<MessageRange> operation) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ranges);
        Function1 & Serializable x$1 = (Function1 & Serializable)range -> {
            scala.collection.immutable.Seq messageIds = ((MapOps)metaData.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)EmailSetUpdatePerformer.$anonfun$updateByRange$2(range, entry)))).keys().toSeq();
            return SMono$.MODULE$.fromCallable(() -> {
                operation.accept((MessageRange)range);
                return (scala.collection.immutable.Seq)messageIds.map((Function1)EmailSetUpdatePerformer$EmailUpdateSuccess$.MODULE$);
            }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just(messageIds.map((Function1 & Serializable)id -> new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed((MessageId)id), (Throwable)e)))).subscribeOn(Schedulers.elastic());
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).reduce((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Function2 & Serializable)(x$14, x$15) -> (scala.collection.immutable.Seq)x$14.$plus$plus((IterableOnce)x$15));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateEachMessage(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validUpdates);
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MessageId messageId = (MessageId)tuple2._1();
            ValidatedEmailSetUpdate updatePatch = (ValidatedEmailSetUpdate)tuple2._2();
            SMono<EmailUpdateResult> sMono = this.updateSingleMessage(messageId, updatePatch, (List<ComposedMessageIdWithMetaData>)((List)metaData.get((Object)messageId).toList().flatten(Predef$.MODULE$.$conforms())), session);
            return sMono;
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
    }

    private SMono<EmailUpdateResult> updateSingleMessage(MessageId messageId, ValidatedEmailSetUpdate update, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)storedMetaData.map((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMailboxId()));
        Flags originFlags = (Flags)storedMetaData.foldLeft((Object)new Flags(), (Function2 & Serializable)(flags, m) -> {
            flags.add(m.getFlags());
            return flags;
        });
        return mailboxIds.value().isEmpty() ? SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), new MessageNotFoundException(messageId))) : this.updateFlags(messageId, update, mailboxIds, originFlags, session).flatMap((Function1 & Serializable)x0$1 -> {
            SMono<EmailUpdateResult> sMono;
            EmailUpdateResult emailUpdateResult = x0$1;
            if (emailUpdateResult instanceof EmailUpdateFailure) {
                EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                sMono = SMono$.MODULE$.just((Object)emailUpdateFailure);
            } else if (emailUpdateResult instanceof EmailUpdateSuccess) {
                sMono = this.updateMailboxIds(messageId, update, mailboxIds, session);
            } else {
                throw new MatchError((Object)emailUpdateResult);
            }
            return sMono;
        }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateMailboxIds(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, MailboxSession session) {
        MailboxIds targetIds = (MailboxIds)update.mailboxIdsTransformation().apply((Object)mailboxIds);
        return targetIds.equals(mailboxIds) ? SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)) : SMono$.MODULE$.fromCallable(() -> {
            this.messageIdManager.setInMailboxes(messageId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(targetIds.value()).asJava(), session);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic()).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateFlags(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, Flags originalFlags, MailboxSession session) {
        Flags newFlags = ((Keywords)update.keywordsTransformation().apply(KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(originalFlags).get())).asFlagsWithRecentAndDeletedFrom(originalFlags);
        return newFlags.equals((Object)originalFlags) ? SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)) : SMono$.MODULE$.fromCallable(() -> {
            this.messageIdManager.setFlags(newFlags, MessageManager.FlagsUpdateMode.REPLACE, messageId, (java.util.List)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(mailboxIds.value()).asJavaCollection()), session);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic()).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    public static final /* synthetic */ boolean $anonfun$updateByRange$2(MessageRange range$1, Tuple2 entry) {
        return ((IterableOnceOps)entry._2()).exists((Function1 & Serializable)composedId -> BoxesRunTime.boxToBoolean((boolean)range$1.includes(composedId.getComposedMessageId().getUid())));
    }

    @Inject
    public EmailSetUpdatePerformer(EmailSetSerializer serializer, MessageIdManager messageIdManager, MailboxManager mailboxManager, MessageId.Factory messageIdFactory) {
        this.serializer = serializer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
    }

    public static class EmailUpdateFailure
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final String unparsedMessageId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String unparsedMessageId() {
            return this.unparsedMessageId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            SetError setError;
            Throwable throwable = this.e();
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                setError = SetError$.MODULE$.invalidPatch(new StringBuilder(27).append("Message update is invalid: ").append(illegalArgumentException.getMessage()).toString());
            } else if (throwable instanceof MailboxNotFoundException) {
                setError = SetError$.MODULE$.notFound("Mailbox not found");
            } else if (throwable instanceof MessageNotFoundException) {
                MessageNotFoundException messageNotFoundException = (MessageNotFoundException)throwable;
                setError = SetError$.MODULE$.notFound(new StringBuilder(36).append("Cannot find message with messageId: ").append(messageNotFoundException.messageId().serialize()).toString());
            } else {
                setError = SetError$.MODULE$.serverFail(this.e().getMessage());
            }
            return setError;
        }

        public EmailUpdateFailure copy(String unparsedMessageId, Throwable e) {
            return new EmailUpdateFailure(unparsedMessageId, e);
        }

        public String copy$default$1() {
            return this.unparsedMessageId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "EmailUpdateFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new Refined((Object)this.unparsedMessageId());
                    break;
                }
                case 1: {
                    object = this.e();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "unparsedMessageId";
                    break;
                }
                case 1: {
                    string2 = "e";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)x$1;
            Refined refined = new Refined((Object)this.unparsedMessageId());
            Refined refined2 = new Refined((Object)emailUpdateFailure.unparsedMessageId());
            if (refined == null) {
                if (refined2 != null) {
                    return false;
                }
            } else if (!refined.equals(refined2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = emailUpdateFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!emailUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateFailure(String unparsedMessageId, Throwable e) {
            this.unparsedMessageId = unparsedMessageId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface EmailUpdateResult {
    }

    public static class EmailUpdateResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<EmailUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> results() {
            return this.results;
        }

        public Option<Map<MessageId, BoxedUnit>> updated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                None$ none$;
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateSuccess) {
                    EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)emailUpdateResult;
                    none$ = new Some((Object)new Tuple2((Object)emailUpdateSuccess.messageId(), (Object)BoxedUnit.UNIT));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<Refined<String, boolean.Not<collection.Empty>>, SetError>> notUpdated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                None$ none$;
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateFailure) {
                    EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                    none$ = new Some((Object)new Tuple2((Object)new Refined((Object)emailUpdateFailure.unparsedMessageId()), (Object)emailUpdateFailure.asMessageSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public EmailUpdateResults copy(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            return new EmailUpdateResults(results);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "EmailUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.results();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "results";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateResults emailUpdateResults = (EmailUpdateResults)x$1;
            scala.collection.immutable.Seq<EmailUpdateResult> seq = this.results();
            scala.collection.immutable.Seq<EmailUpdateResult> seq2 = emailUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!emailUpdateResults.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateResults(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class EmailUpdateSuccess
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final MessageId messageId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MessageId messageId() {
            return this.messageId;
        }

        public EmailUpdateSuccess copy(MessageId messageId) {
            return new EmailUpdateSuccess(messageId);
        }

        public MessageId copy$default$1() {
            return this.messageId();
        }

        public String productPrefix() {
            return "EmailUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.messageId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "messageId";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)x$1;
            MessageId messageId = this.messageId();
            MessageId messageId2 = emailUpdateSuccess.messageId();
            if (messageId == null) {
                if (messageId2 != null) {
                    return false;
                }
            } else if (!messageId.equals(messageId2)) return false;
            if (!emailUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateSuccess(MessageId messageId) {
            this.messageId = messageId;
            Product.$init$((Product)this);
        }
    }
}

