/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u0005\u000b\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)Q\u0006\u0001C\u0001]!)A\b\u0001C\u0001{!)A\u000b\u0001C\u0005+\")q\u000b\u0001C\u00051\"9\u00111\u0004\u0001\u0005\n\u0005u\u0001BBA\u001a\u0001\u0011%QO\u0001\tVg\u0016\u0014\bK]8wSNLwN\\5oO*\u00111\u0002D\u0001\u0005QR$\bO\u0003\u0002\u000e\u001d\u0005!!.\\1q\u0015\ty\u0001#A\u0003kC6,7O\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017aD;tKJ\u001c(+\u001a9pg&$xN]=\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013aA1qS*\u0011!ED\u0001\u0005kN,'/\u0003\u0002%?\tyQk]3sgJ+\u0007o\\:ji>\u0014\u00180A\u0007nKR\u0014\u0018n\u0019$bGR|'/\u001f\t\u0003O-j\u0011\u0001\u000b\u0006\u0003A%R!A\u000b\b\u0002\u000f5,GO]5dg&\u0011A\u0006\u000b\u0002\u000e\u001b\u0016$(/[2GC\u000e$xN]=\u0002\rqJg.\u001b;?)\ry\u0013G\r\t\u0003a\u0001i\u0011A\u0003\u0005\u00069\r\u0001\r!\b\u0005\u0006K\r\u0001\rA\n\u0015\u0003\u0007Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\r%t'.Z2u\u0015\u0005I\u0014!\u00026bm\u0006D\u0018BA\u001e7\u0005\u0019IeN[3di\u0006i\u0001O]8wSNLwN\\+tKJ$\"A\u0010'\u0011\u0007}:\u0015*D\u0001A\u0015\t\t%)A\u0005qk\nd\u0017n\u001d5fe*\u0011\u0011d\u0011\u0006\u0003\t\u0016\u000bAaY8sK*\ta)A\u0004sK\u0006\u001cGo\u001c:\n\u0005!\u0003%!B*N_:|\u0007CA\fK\u0013\tY\u0005D\u0001\u0003V]&$\b\"B'\u0005\u0001\u0004q\u0015aB:fgNLwN\u001c\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#:\tq!\\1jY\n|\u00070\u0003\u0002T!\nqQ*Y5mE>D8+Z:tS>t\u0017!F2sK\u0006$X-Q2d_VtG/\u00134OK\u0016$W\r\u001a\u000b\u0003\u0013ZCQ!T\u0003A\u00029\u000bQb\u0019:fCR,\u0017iY2pk:$HCA%Z\u0011\u0015Qf\u00011\u0001\\\u0003!)8/\u001a:oC6,\u0007C\u0001/_\u001b\u0005i&B\u0001#\u000f\u0013\tyVL\u0001\u0005Vg\u0016\u0014h.Y7fQ\r1\u0011m\u001a\t\u0004/\t$\u0017BA2\u0019\u0005\u0019!\bN]8xgB\u0011a$Z\u0005\u0003M~\u0011\u0001$V:feN\u0014V\r]8tSR|'/_#yG\u0016\u0004H/[8oc\u0015q\u0002n]A\r!\tI\u0007O\u0004\u0002k]B\u00111\u000eG\u0007\u0002Y*\u0011Q\u000eF\u0001\u0007yI|w\u000e\u001e \n\u0005=D\u0012A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c\r2\r\r\"\b0a\u0004z+\t)h/F\u0001i\t\u00159HC1\u0001}\u0005\u0005!\u0016BA={\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u00111\u0010G\u0001\u0007i\"\u0014xn^:\u0012\u0007u\f\t\u0001\u0005\u0002\u0018}&\u0011q\u0010\u0007\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019!!\u0003\u000f\u0007]\t)!C\u0002\u0002\ba\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00055!!\u0003+ie><\u0018M\u00197f\u0015\r\t9\u0001G\u0019\tG\u0005E\u00111CA\u000bw:\u0019q#a\u0005\n\u0005mD\u0012'\u0002\u0012\u00181\u0005]!!B:dC2\f\u0017G\u0001\u0014e\u0003QqW-\u001a3t\u0003\u000e\u001cw.\u001e8u\u0007J,\u0017\r^5p]R!\u0011qDA\u0013!\r9\u0012\u0011E\u0005\u0004\u0003GA\"a\u0002\"p_2,\u0017M\u001c\u0005\u00065\u001e\u0001\ra\u0017\u0015\u0005\u000f\u0005\fI#\r\u0004\u001fQ\u0006-\u0012\u0011G\u0019\u0007GQD\u0018QF=2\u0011\r\n\t\"a\u0005\u00020m\fTAI\f\u0019\u0003/\t$A\n3\u0002!\u001d,g.\u001a:bi\u0016\u0004\u0016m]:x_J$\u0007")
public class UserProvisioning {
    private final UsersRepository usersRepository;
    private final MetricFactory metricFactory;

    public SMono<BoxedUnit> provisionUser(MailboxSession session) {
        return session != null && !this.usersRepository.isReadOnly() ? SMono$.MODULE$.fromCallable(() -> {
            this.createAccountIfNeeded(session);
            return BoxedUnit.UNIT;
        }).then() : SMono$.MODULE$.empty();
    }

    private void createAccountIfNeeded(MailboxSession session) {
        TimeMetric timeMetric = this.metricFactory.timer("JMAP-RFC-8621-user-provisioning");
        try {
            try {
                Username username = session.getUser();
                if (this.needsAccountCreation(username)) {
                    this.createAccount(username);
                }
            }
            catch (AlreadyExistInUsersRepositoryException exception) {
            }
            catch (UsersRepositoryException exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            timeMetric.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD);
        }
    }

    private void createAccount(Username username) throws UsersRepositoryException {
        this.usersRepository.addUser(username, this.generatePassword());
    }

    private boolean needsAccountCreation(Username username) throws UsersRepositoryException {
        return !this.usersRepository.contains(username);
    }

    private String generatePassword() {
        return UUID.randomUUID().toString();
    }

    @Inject
    public UserProvisioning(UsersRepository usersRepository, MetricFactory metricFactory) {
        this.usersRepository = usersRepository;
        this.metricFactory = metricFactory;
    }
}

