/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import java.io.Serializable;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.DefaultMailboxes;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0004D\u0001\t\u0007I\u0011\u0002#\t\r-\u0003\u0001\u0015!\u0003F\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0007\u0001\"\u0003c\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0015I\b\u0001\"\u0003{\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\u0011A#T1jY\n|\u00070Z:Qe>4\u0018n]5p]\u0016\u0014(B\u0001\b\u0010\u0003\u0011AG\u000f\u001e9\u000b\u0005A\t\u0012\u0001\u00026nCBT!AE\n\u0002\u000b)\fW.Z:\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u000f[\u0006LGNY8y\u001b\u0006t\u0017mZ3s!\t\tC%D\u0001#\u0015\t\u0019\u0013#A\u0004nC&d'm\u001c=\n\u0005\u0015\u0012#AD'bS2\u0014w\u000e_'b]\u0006<WM]\u0001\u0014gV\u00147o\u0019:jaRLwN\\'b]\u0006<WM\u001d\t\u0003C!J!!\u000b\u0012\u0003'M+(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0002\u001b5,GO]5d\r\u0006\u001cGo\u001c:z!\ta\u0013'D\u0001.\u0015\tqs&A\u0002ba&T!\u0001M\t\u0002\u000f5,GO]5dg&\u0011!'\f\u0002\u000e\u001b\u0016$(/[2GC\u000e$xN]=\u0002\rqJg.\u001b;?)\u0011)t\u0007O\u001d\u0011\u0005Y\u0002Q\"A\u0007\t\u000b}!\u0001\u0019\u0001\u0011\t\u000b\u0019\"\u0001\u0019A\u0014\t\u000b)\"\u0001\u0019A\u0016)\u0005\u0011Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0019IgN[3di*\t\u0001)A\u0003kCZ\f\u00070\u0003\u0002C{\t1\u0011J\u001c6fGR\fa\u0001T(H\u000f\u0016\u0013V#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!+\u0012!B:mMRR\u0017B\u0001&H\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u0003\u0013aF2sK\u0006$X-T1jY\n|\u00070Z:JM:+W\rZ3e)\tqE\fE\u0002P/fk\u0011\u0001\u0015\u0006\u0003#J\u000b\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005q\u0019&B\u0001+V\u0003\u0011\u0019wN]3\u000b\u0003Y\u000bqA]3bGR|'/\u0003\u0002Y!\n)1+T8o_B\u0011!DW\u0005\u00037n\u0011A!\u00168ji\")Ql\u0002a\u0001=\u000691/Z:tS>t\u0007CA\u0011`\u0013\t\u0001'E\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0002-\r\u0014X-\u0019;f\t\u00164\u0017-\u001e7u\u001b\u0006LGNY8yKN$\"AT2\t\u000b\u0011D\u0001\u0019A3\u0002\u0011U\u001cXM\u001d8b[\u0016\u0004\"A\u001a5\u000e\u0003\u001dT!\u0001V\t\n\u0005%<'\u0001C+tKJt\u0017-\\3\u0002%5\f\u0017\u000e\u001c2pq\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u000b\u0004YBD\bcA(X[B\u0011!D\\\u0005\u0003_n\u0011qAQ8pY\u0016\fg\u000eC\u0003r\u0013\u0001\u0007!/A\u0006nC&d'm\u001c=QCRD\u0007CA:w\u001b\u0005!(BA;#\u0003\u0015iw\u000eZ3m\u0013\t9HOA\u0006NC&d'm\u001c=QCRD\u0007\"B/\n\u0001\u0004q\u0016!\u0004;p\u001b\u0006LGNY8y!\u0006$\b\u000eF\u0002|\u0003'\u0001BA\u0007?\u007fe&\u0011Qp\u0007\u0002\n\rVt7\r^5p]F\u00022a`A\u0007\u001d\u0011\t\t!!\u0003\u0011\u0007\u0005\r1$\u0004\u0002\u0002\u0006)\u0019\u0011qA\f\u0002\rq\u0012xn\u001c;?\u0013\r\tYaG\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-1\u0004C\u0003^\u0015\u0001\u0007a,A\u0007de\u0016\fG/Z'bS2\u0014w\u000e\u001f\u000b\u00063\u0006e\u00111\u0004\u0005\u0006c.\u0001\rA\u001d\u0005\u0006;.\u0001\rA\u0018")
public class MailboxesProvisioner {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MetricFactory metricFactory;
    private final Logger LOGGER;

    private Logger LOGGER() {
        return this.LOGGER;
    }

    public SMono<BoxedUnit> createMailboxesIfNeeded(MailboxSession session) {
        return (SMono)this.metricFactory.decorateSupplierWithTimerMetric("JMAP-RFC-8621-mailboxes-provisioning", () -> this.createDefaultMailboxes(session.getUser()));
    }

    private SMono<BoxedUnit> createDefaultMailboxes(Username username) {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(DefaultMailboxes.DEFAULT_MAILBOXES).asScala()).map(this.toMailboxPath(session));
        Function1 & Serializable x$1 = (Function1 & Serializable)mailboxPath -> this.mailboxDoesntExist((MailboxPath)mailboxPath, session);
        int x$2 = qual$1.filterWhen$default$2();
        SFlux qual$2 = qual$1.filterWhen((Function1)x$1, x$2);
        Function1 & Serializable x$3 = (Function1 & Serializable)mailboxPath -> SMono$.MODULE$.fromCallable(() -> {
            this.createMailbox(mailboxPath, session);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic());
        int x$4 = qual$2.concatMap$default$2();
        return qual$2.concatMap((Function1)x$3, x$4).then();
    }

    private SMono<Object> mailboxDoesntExist(MailboxPath mailboxPath, MailboxSession session) {
        SMono sMono;
        try {
            sMono = SMono$.MODULE$.apply(this.mailboxManager.mailboxExists(mailboxPath, session)).map((Function1 & Serializable)exist -> BoxesRunTime.boxToBoolean((boolean)MailboxesProvisioner.$anonfun$mailboxDoesntExist$1(exist)));
        }
        catch (MailboxException exception) {
            sMono = SMono$.MODULE$.raiseError((Throwable)exception);
        }
        return sMono;
    }

    private Function1<String, MailboxPath> toMailboxPath(MailboxSession session) {
        return (Function1 & Serializable)mailbox -> MailboxPath.forUser((Username)session.getUser(), (String)mailbox);
    }

    private void createMailbox(MailboxPath mailboxPath, MailboxSession session) {
        try {
            Optional mailboxId = this.mailboxManager.createMailbox(mailboxPath, session);
            if (mailboxId.isPresent()) {
                this.subscriptionManager.subscribe(session, mailboxPath.getName());
            }
            this.LOGGER().info("Provisioning {}. {} created.", (Object)mailboxPath, (Object)mailboxId);
        }
        catch (MailboxExistsException e) {
            this.LOGGER().info("Mailbox {} have been created concurrently", (Object)mailboxPath);
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$mailboxDoesntExist$1(Boolean exist) {
        return !Predef$.MODULE$.Boolean2boolean(exist);
    }

    @Inject
    public MailboxesProvisioner(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.metricFactory = metricFactory;
        this.LOGGER = LoggerFactory.getLogger(MailboxesProvisioner.class);
    }
}

