/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class UseHeaderRecipients
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UseHeaderRecipients.class);
    private boolean isDebug = false;

    public void init() {
        this.isDebug = this.getInitParameter("debug") == null ? false : Boolean.parseBoolean(this.getInitParameter("debug"));
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        mail.setRecipients(this.headersAddresses(message));
        if (this.isDebug) {
            LOGGER.debug("All recipients = {}", (Object)mail.getRecipients());
            LOGGER.debug("Reprocessing mail using recipients in message headers");
        }
        this.getMailetContext().sendMail(mail.duplicate());
        mail.setState("ghost");
    }

    public Collection<MailAddress> headersAddresses(MimeMessage mimeMessage) throws MessagingException {
        Collection<MailAddress> mailForHeaderAddresses = this.getHeaderMailAddresses(mimeMessage, "Mail-For");
        if (!mailForHeaderAddresses.isEmpty()) {
            return mailForHeaderAddresses;
        }
        return ImmutableList.builder().addAll(this.getHeaderMailAddresses(mimeMessage, "To")).addAll(this.getHeaderMailAddresses(mimeMessage, "Cc")).addAll(this.getHeaderMailAddresses(mimeMessage, "Bcc")).build();
    }

    public String getMailetInfo() {
        return "UseHeaderRecipients Mailet";
    }

    private Collection<MailAddress> getHeaderMailAddresses(MimeMessage message, String name) throws MessagingException {
        if (this.isDebug) {
            LOGGER.debug("Checking {} headers", (Object)name);
        }
        String[] headers = message.getHeader(name);
        ImmutableList.Builder addresses = ImmutableList.builder();
        if (headers != null) {
            for (String header : headers) {
                addresses.addAll(this.getMailAddressesFromHeaderLine(header));
            }
        }
        return addresses.build();
    }

    private ImmutableList<MailAddress> getMailAddressesFromHeaderLine(String header) throws MessagingException {
        String unfoldedDecodedString = this.sanitizeHeaderString(header);
        Iterable headerParts = Splitter.on((String)",").split((CharSequence)unfoldedDecodedString);
        return this.getMailAddressesFromHeadersParts(headerParts);
    }

    private ImmutableList<MailAddress> getMailAddressesFromHeadersParts(Iterable<String> headerParts) throws AddressException {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String headerPart : headerParts) {
            if (this.isDebug) {
                LOGGER.debug("Address = {}", (Object)headerPart);
            }
            result.addAll(this.readMailAddresses(headerPart));
        }
        return result.build();
    }

    private Collection<MailAddress> readMailAddresses(String headerPart) throws AddressException {
        AddressList addressList = LenientAddressParser.DEFAULT.parseAddressList((CharSequence)MimeUtil.unfold((String)headerPart));
        return (Collection)addressList.stream().flatMap(address -> this.convertAddressToMailboxCollection((Address)address)).map(this::toMailAddress).collect(Guavate.toImmutableList());
    }

    private MailAddress toMailAddress(Mailbox mailbox) {
        try {
            return new MailAddress(mailbox.getAddress());
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Mailbox> convertAddressToMailboxCollection(Address address) {
        if (address instanceof Mailbox) {
            return ImmutableList.of((Object)((Mailbox)address)).stream();
        }
        if (address instanceof Group) {
            return ImmutableList.copyOf((Collection)((Group)address).getMailboxes()).stream();
        }
        return Stream.of(new Mailbox[0]);
    }

    private String sanitizeHeaderString(String header) throws MessagingException {
        try {
            return MimeUtility.unfold((String)MimeUtility.decodeText((String)header));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Can not decode header", (Exception)e);
        }
    }
}

