/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.Closeable;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxConnection
implements Closeable {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final int defaultPort = 9999;
    private final JMXConnector jmxConnector;

    public static JmxConnection defaultJmxConnection(String host) throws IOException {
        return new JmxConnection(host, 9999);
    }

    public JmxConnection(String host, int port) throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, host, port));
        this.jmxConnector = JMXConnectorFactory.connect(jmxUrl, null);
    }

    @Override
    public void close() throws IOException {
        this.jmxConnector.close();
    }

    public <T> T retrieveBean(Class<T> mbeanType, String name) throws MalformedObjectNameException, IOException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServerConnection(), new ObjectName(name), mbeanType, true);
    }

    private MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.jmxConnector.getMBeanServerConnection();
    }
}

