/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class ModSeq
implements Comparable<ModSeq> {
    private final long modSeq;

    public static ModSeq of(long modSeq) {
        return new ModSeq(modSeq);
    }

    public static ModSeq first() {
        return ModSeq.of(0L);
    }

    private ModSeq(long modSeq) {
        Preconditions.checkArgument((modSeq >= 0L ? 1 : 0) != 0, (Object)"A modseq needs to be positive");
        this.modSeq = modSeq;
    }

    public long asLong() {
        return this.modSeq;
    }

    public ModSeq next() {
        if (this.modSeq == Long.MAX_VALUE) {
            throw new RuntimeException("Long overflow upon modseq generation");
        }
        return new ModSeq(this.modSeq + 1L);
    }

    public boolean isFirst() {
        return this.equals(ModSeq.first());
    }

    @Override
    public int compareTo(ModSeq o) {
        return Long.compare(this.modSeq, o.modSeq);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modSeq});
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ModSeq) {
            ModSeq other = (ModSeq)obj;
            return other.modSeq == this.modSeq;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.modSeq).toString();
    }
}

