/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.jdkim.api.Headers;

final class MimeMessageHeaders
implements Headers {
    private final ImmutableListMultimap<String, String> headers;
    private final List<String> fields;

    public MimeMessageHeaders(MimeMessage message) throws MessagingException {
        ImmutableList headsAndLines = (ImmutableList)Streams.stream((Iterator)Iterators.forEnumeration((Enumeration)message.getAllHeaderLines())).map(Throwing.function(this::extractHeaderLine).sneakyThrow()).collect(Guavate.toImmutableList());
        this.fields = (List)headsAndLines.stream().map(Pair::getKey).collect(Guavate.toImmutableList());
        this.headers = (ImmutableListMultimap)headsAndLines.stream().collect(Guavate.toImmutableListMultimap(pair -> ((String)pair.getKey()).toLowerCase(Locale.US), Pair::getValue));
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getFields(String name) {
        return this.headers.get((Object)name.toLowerCase(Locale.US));
    }

    private Pair<String, String> extractHeaderLine(String header) throws MessagingException {
        int fieldSeperatorPosition = header.indexOf(58);
        if (fieldSeperatorPosition <= 0) {
            throw new MessagingException("Bad header line: " + header);
        }
        return Pair.of((Object)header.substring(0, fieldSeperatorPosition).trim(), (Object)header);
    }
}

