/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCClassFileTransformer;
import org.apache.openjpa.enhance.PCEnhancerAgent;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistenceUtil;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.osgi.BundleUtils;
import org.apache.openjpa.persistence.validation.ValidationUtils;
import org.apache.openjpa.util.ClassResolver;

public class PersistenceProviderImpl
implements PersistenceProvider,
ProviderUtil {
    static final String CLASS_TRANSFORMER_OPTIONS = "ClassTransformerOptions";
    private static final String EMF_POOL = "EntityManagerFactoryPool";
    private static final Localizer _loc = Localizer.forPackage(PersistenceProviderImpl.class);
    private Log _log;

    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, String resource, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty(EMF_POOL, m);
            ConfigurationProvider cp = pd.load(resource, name, m);
            if (cp == null) {
                return null;
            }
            BrokerFactory factory = this.getBrokerFactory(cp, poolValue, BundleUtils.getBundleClassLoader());
            OpenJPAConfiguration conf = factory.getConfiguration();
            conf.setUserClassLoader(BundleUtils.getBundleClassLoader());
            this._log = conf.getLog("openjpa.Runtime");
            pd.checkPuNameCollisions(this._log, name);
            this.loadAgent(factory);
            this.loadValidator(factory);
            if (conf.getConnectionRetainModeConstant() == 2) {
                this._log.warn(_loc.get("retain-always", conf.getId()));
            }
            OpenJPAEntityManagerFactory emf = JPAFacadeHelper.toEntityManagerFactory(factory);
            if (this._log.isTraceEnabled()) {
                this._log.trace(this + " creating " + emf + " for PU " + name + ".");
            }
            return emf;
        }
        catch (Exception e) {
            if (this._log != null) {
                this._log.error(_loc.get("create-emf-error", name), e);
            }
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    private BrokerFactory getBrokerFactory(ConfigurationProvider cp, Object poolValue, ClassLoader loader) {
        if (poolValue instanceof String && ("true".equalsIgnoreCase((String)poolValue) || "false".equalsIgnoreCase((String)poolValue))) {
            poolValue = Boolean.valueOf((String)poolValue);
        }
        if (poolValue != null && !(poolValue instanceof Boolean)) {
            throw new IllegalArgumentException(poolValue.toString());
        }
        if (poolValue == null || !((Boolean)poolValue).booleanValue()) {
            return Bootstrap.newBrokerFactory(cp, loader);
        }
        return Bootstrap.getBrokerFactory(cp, loader);
    }

    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, Map m) {
        return this.createEntityManagerFactory(name, null, m);
    }

    public OpenJPAEntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo pui, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty(EMF_POOL, m);
            ConfigurationProvider cp = pd.load(pui, m);
            if (cp == null) {
                return null;
            }
            Exception transformerException = null;
            String ctOpts = (String)Configurations.getProperty(CLASS_TRANSFORMER_OPTIONS, pui.getProperties());
            try {
                pui.addTransformer((ClassTransformer)new ClassTransformerImpl(cp, ctOpts, pui.getNewTempClassLoader(), this.newConfigurationImpl()));
            }
            catch (Exception e) {
                transformerException = e;
            }
            if (!Configurations.containsProperty("BrokerImpl", cp.getProperties())) {
                cp.addProperty("openjpa.BrokerImpl", this.getDefaultBrokerAlias());
            }
            ClassLoader loader = pui.getClassLoader();
            if (BundleUtils.runningUnderOSGi()) {
                loader = new MultiClassLoader(BundleUtils.getBundleClassLoader(), loader);
            }
            BrokerFactory factory = this.getBrokerFactory(cp, poolValue, loader);
            OpenJPAConfiguration conf = factory.getConfiguration();
            this.setPersistenceEnvironmentInfo(conf, pui);
            this._log = conf.getLog("openjpa.Runtime");
            if (transformerException != null) {
                if (this._log.isTraceEnabled()) {
                    this._log.warn(_loc.get("transformer-registration-error-ex", pui), transformerException);
                } else {
                    this._log.warn(_loc.get("transformer-registration-error", pui));
                }
            }
            if (conf.getConnectionRetainModeConstant() == 2) {
                this._log.warn(_loc.get("cm-retain-always", conf.getId()));
            }
            this.loadValidator(factory);
            OpenJPAEntityManagerFactory emf = JPAFacadeHelper.toEntityManagerFactory(factory);
            if (this._log.isTraceEnabled()) {
                this._log.trace(this + " creating container " + emf + " for PU " + pui.getPersistenceUnitName() + ".");
            }
            return emf;
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSchema(PersistenceUnitInfo info, Map map) {
        HashMap<String, String> runMap = map == null ? new HashMap<String, String>() : new HashMap(map);
        runMap.put("javax.persistence.schema-generation.database.action", "create");
        try (OpenJPAEntityManagerFactory factory = this.createContainerEntityManagerFactory(info, runMap);){
            this.synchronizeMappings(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateSchema(String persistenceUnitName, Map map) {
        HashMap<String, String> runMap = map == null ? new HashMap<String, String>() : new HashMap(map);
        runMap.put("javax.persistence.schema-generation.database.action", "create");
        try (OpenJPAEntityManagerFactory factory = this.createEntityManagerFactory(persistenceUnitName, runMap);){
            Object obj = this.synchronizeMappings(factory);
            boolean bl = (Boolean)Boolean.class.cast(obj) != false ? (Boolean)Boolean.class.cast(obj) : true;
            return bl;
        }
    }

    private Object synchronizeMappings(OpenJPAEntityManagerFactory factory) {
        if (EntityManagerFactoryImpl.class.isInstance(factory)) {
            EntityManagerFactoryImpl entityManagerFactory = (EntityManagerFactoryImpl)EntityManagerFactoryImpl.class.cast(factory);
            BrokerFactory brokerFactory = entityManagerFactory.getBrokerFactory();
            if (!AbstractBrokerFactory.class.isInstance(brokerFactory)) {
                throw new IllegalArgumentException("expected AbstractBrokerFactory but got " + brokerFactory);
            }
            try {
                Method synchronizeMappings = brokerFactory.getClass().getDeclaredMethod("synchronizeMappings", ClassLoader.class);
                if (!synchronizeMappings.isAccessible()) {
                    synchronizeMappings.setAccessible(true);
                }
                return synchronizeMappings.invoke((Object)brokerFactory, Thread.currentThread().getContextClassLoader());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (RuntimeException.class.isInstance(targetException)) {
                    throw (RuntimeException)RuntimeException.class.cast(targetException);
                }
                throw new IllegalStateException(targetException);
            }
        }
        throw new IllegalArgumentException("expected EntityManagerFactoryImpl but got " + factory);
    }

    public void setPersistenceEnvironmentInfo(OpenJPAConfiguration conf, PersistenceUnitInfo pui) {
        if (conf instanceof OpenJPAConfigurationImpl) {
            Map<String, Object> peMap = ((OpenJPAConfigurationImpl)conf).getPersistenceEnvironment();
            if (peMap == null) {
                peMap = new HashMap<String, Object>();
                ((OpenJPAConfigurationImpl)conf).setPersistenceEnvironment(peMap);
            }
            peMap.put("PersistenceUnitRootUrl", pui.getPersistenceUnitRootUrl());
            peMap.put("MappingFileNames", pui.getMappingFileNames());
            peMap.put("JarFiles", pui.getJarFileUrls());
        }
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }

    protected String getDefaultBrokerAlias() {
        return "non-finalizing";
    }

    protected OpenJPAConfiguration newConfigurationImpl() {
        return new OpenJPAConfigurationImpl();
    }

    private void loadAgent(BrokerFactory factory) {
        OpenJPAConfiguration conf = factory.getConfiguration();
        Log log = conf.getLog("openjpa.Runtime");
        if (conf.getDynamicEnhancementAgent()) {
            boolean res = PCEnhancerAgent.loadDynamicAgent(log);
            if (log.isInfoEnabled() && res) {
                log.info(_loc.get("dynamic-agent"));
            }
        }
    }

    private void loadValidator(BrokerFactory factory) {
        OpenJPAConfiguration conf = factory.getConfiguration();
        Log log = conf.getLog("openjpa.Runtime");
        if (ValidationUtils.setupValidation(conf) && log.isInfoEnabled()) {
            log.info(_loc.get("vlem-creation-info"));
        }
    }

    public LoadState isLoaded(Object obj) {
        return this.isLoadedWithoutReference(obj, null);
    }

    public LoadState isLoadedWithReference(Object obj, String attr) {
        return this.isLoadedWithoutReference(obj, attr);
    }

    public LoadState isLoadedWithoutReference(Object obj, String attr) {
        if (obj == null) {
            return LoadState.UNKNOWN;
        }
        return OpenJPAPersistenceUtil.isLoaded(obj, attr);
    }

    private static class ClassTransformerImpl
    implements ClassTransformer {
        private final ClassFileTransformer _trans;

        private ClassTransformerImpl(ConfigurationProvider cp, String props, final ClassLoader tmpLoader, OpenJPAConfiguration conf) {
            cp.setInto(conf);
            conf.setClassResolver(new ClassResolver(){

                @Override
                public ClassLoader getClassLoader(Class<?> context, ClassLoader env) {
                    return tmpLoader;
                }
            });
            conf.setReadOnly(1);
            MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
            repos.setResolve(2, false);
            this._trans = new PCClassFileTransformer(repos, Configurations.parseProperties(props), tmpLoader);
        }

        public byte[] transform(ClassLoader cl, String name, Class<?> previousVersion, ProtectionDomain pd, byte[] bytes) throws IllegalClassFormatException {
            return this._trans.transform(cl, name, previousVersion, pd, bytes);
        }
    }
}

