/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib.model;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import org.apache.james.core.Username;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.model.Algorithm;
import org.apache.james.user.lib.util.DigestUtil;

public class DefaultUser
implements User,
Serializable {
    private static final long serialVersionUID = 5178048915868531270L;
    private final Username userName;
    private String hashedPassword;
    private final Algorithm algorithm;

    public DefaultUser(Username name, Algorithm hashAlg) {
        this.userName = name;
        this.algorithm = hashAlg;
    }

    public DefaultUser(Username name, String passwordHash, Algorithm hashAlg) {
        this.userName = name;
        this.hashedPassword = passwordHash;
        this.algorithm = hashAlg;
    }

    public Username getUserName() {
        return this.userName;
    }

    public boolean verifyPassword(String pass) {
        try {
            String hashGuess = DigestUtil.digestString(pass, this.algorithm);
            return this.hashedPassword.equals(hashGuess);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Security error: " + nsae);
        }
    }

    public boolean setPassword(String newPass) {
        try {
            this.hashedPassword = DigestUtil.digestString(newPass, this.algorithm);
            return true;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Security error: " + nsae);
        }
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public Algorithm getHashAlgorithm() {
        return this.algorithm;
    }
}

