/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.mail.internet.AddressException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;

public class Username {
    public static final int MAXIMUM_MAIL_ADDRESS_LENGTH = 255;
    private final String localPart;
    private final Optional<Domain> domainPart;

    public static Username of(String username) {
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username should not be null or empty");
        Preconditions.checkArgument((!username.trim().isEmpty() ? 1 : 0) != 0, (Object)"username should not be null or empty after being trimmed");
        Preconditions.checkArgument((username.length() <= 255 ? 1 : 0) != 0, (String)"username length should not be longer than %s characters", (int)255);
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)'@').split((CharSequence)username));
        switch (parts.size()) {
            case 1: {
                return Username.fromLocalPartWithoutDomain(username);
            }
            case 2: {
                return Username.fromLocalPartWithDomain((String)parts.get(0), (String)parts.get(1));
            }
        }
        throw new IllegalArgumentException("The username should not contain multiple domain delimiter. Value: " + username);
    }

    public static Username fromLocalPartWithDomain(String localPart, String domain) {
        Preconditions.checkNotNull((Object)domain);
        return Username.fromLocalPartWithDomain(localPart, Domain.of(domain));
    }

    public static Username fromLocalPartWithDomain(String localPart, Domain domain) {
        Preconditions.checkNotNull((Object)domain);
        return new Username(localPart, Optional.of(domain));
    }

    public static Username fromMailAddress(MailAddress address) {
        Preconditions.checkNotNull((Object)address);
        return new Username(address.getLocalPart(), Optional.of(address.getDomain()));
    }

    public static Username fromLocalPartWithoutDomain(String localPart) {
        return Username.from(localPart, Optional.empty());
    }

    public static Username from(String localPart, Optional<String> domain) {
        return new Username(localPart, domain.map(Domain::of));
    }

    private Username(String localPart, Optional<Domain> domainPart) {
        Preconditions.checkNotNull((Object)localPart);
        Preconditions.checkArgument((!localPart.isEmpty() ? 1 : 0) != 0, (Object)"username local part should not be empty");
        Preconditions.checkArgument((!localPart.contains("@") ? 1 : 0) != 0, (String)"username local part can not contain domain delimiter, got %s", (Object)localPart);
        this.localPart = localPart.toLowerCase(Locale.US);
        this.domainPart = domainPart;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public Optional<Domain> getDomainPart() {
        return this.domainPart;
    }

    public Username withOtherDomain(Optional<Domain> domain) {
        return new Username(this.localPart, domain);
    }

    public Username withOtherDomain(Domain domain) {
        return this.withOtherDomain(Optional.of(domain));
    }

    public boolean hasDomainPart() {
        return this.domainPart.isPresent();
    }

    public Username withDefaultDomain(Optional<Domain> defaultDomain) {
        if (this.hasDomainPart()) {
            return this;
        }
        return new Username(this.localPart, defaultDomain);
    }

    public Username withDefaultDomain(Domain defaultDomain) {
        return this.withDefaultDomain(Optional.of(defaultDomain));
    }

    public Username withDefaultDomainFromUser(Username other) {
        return this.withDefaultDomain(other.domainPart);
    }

    public String asString() {
        return this.domainPart.map(domain -> this.localPart + "@" + domain.asString()).orElse(this.localPart);
    }

    public MailAddress asMailAddress() throws AddressException {
        Preconditions.checkState((boolean)this.hasDomainPart());
        return new MailAddress(this.localPart, this.domainPart.get());
    }

    public final boolean equals(Object o) {
        if (o instanceof Username) {
            Username username = (Username)o;
            return Objects.equals(this.localPart, username.localPart) && Objects.equals(this.domainPart, username.domainPart);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.localPart, this.domainPart);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("localPart", (Object)this.localPart).add("domainPart", this.domainPart).toString();
    }
}

