/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public class Domain
implements Serializable {
    public static final Domain LOCALHOST = Domain.of("localhost");
    public static final int MAXIMUM_DOMAIN_LENGTH = 255;
    private final String domainName;
    private final String normalizedDomainName;

    private static String removeBrackets(String domainName) {
        if (!domainName.startsWith("[") || !domainName.endsWith("]")) {
            return domainName;
        }
        return domainName.substring(1, domainName.length() - 1);
    }

    public static Domain of(String domain) {
        Preconditions.checkNotNull((Object)domain, (Object)"Domain can not be null");
        Preconditions.checkArgument((!domain.isEmpty() && !domain.contains("@") && !domain.contains("/") ? 1 : 0) != 0, (Object)"Domain can not be empty nor contain `@` nor `/`");
        Preconditions.checkArgument((domain.length() <= 255 ? 1 : 0) != 0, (String)"Domain name length should not exceed %s characters", (int)255);
        return new Domain(domain);
    }

    protected Domain(String domainName) {
        this.domainName = domainName;
        this.normalizedDomainName = Domain.removeBrackets(domainName.toLowerCase(Locale.US));
    }

    public String name() {
        return this.domainName;
    }

    public String asString() {
        return this.normalizedDomainName;
    }

    public final boolean equals(Object o) {
        if (o instanceof Domain) {
            Domain domain = (Domain)o;
            return Objects.equals(this.normalizedDomainName, domain.normalizedDomainName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.normalizedDomainName);
    }

    public String toString() {
        return "Domain : " + this.domainName;
    }
}

