/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.james.mailbox.store.mail.model.Property;

public class Properties {
    private Long textualLineCount;
    private final ImmutableList<Property> properties;

    public Properties(List<Property> props, Long textualLineCount) {
        this.textualLineCount = textualLineCount;
        this.properties = ImmutableList.copyOf(props);
    }

    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    private String getFirstValue(String namespace, String localName) {
        return this.properties.stream().filter(property -> property.isNamed(namespace, localName)).findFirst().map(Property::getValue).orElse(null);
    }

    private List<String> getValues(String namespace, String localName) {
        return (List)this.properties.stream().filter(property -> property.isNamed(namespace, localName)).map(Property::getValue).collect(Guavate.toImmutableList());
    }

    private SortedMap<String, String> getProperties(String namespace) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        for (Property property : this.properties) {
            if (!property.isInSpace(namespace)) continue;
            parameters.put(property.getLocalName(), property.getValue());
        }
        return parameters;
    }

    public String getMediaType() {
        return this.getFirstValue("http://james.apache.org/rfc2045/Content-Type", "type");
    }

    public String getSubType() {
        return this.getFirstValue("http://james.apache.org/rfc2045/Content-Type", "subtype");
    }

    public String getContentID() {
        return this.getFirstValue("http://james.apache.org/rfc2045", "Content-ID");
    }

    public String getContentDescription() {
        return this.getFirstValue("http://james.apache.org/rfc2045", "Content-Description");
    }

    public String getContentTransferEncoding() {
        return this.getFirstValue("http://james.apache.org/rfc2045", "Content-Transfer-Encoding");
    }

    public String getContentLocation() {
        return this.getFirstValue("http://james.apache.org/rfc2557", "Content-Location");
    }

    public String getContentDispositionType() {
        return this.getFirstValue("http://james.apache.org/rfc2183Content-Disposition", "disposition-type");
    }

    public Map<String, String> getContentDispositionParameters() {
        return this.getProperties("http://james.apache.org/rfc2183Content-Disposition/params");
    }

    public Map<String, String> getContentTypeParameters() {
        return this.getProperties("http://james.apache.org/rfc2045/Content-Type/params");
    }

    public String getContentMD5() {
        return this.getFirstValue("http://james.apache.org/rfc1864", "Content-MD5");
    }

    public List<String> getContentLanguage() {
        return this.getValues("http://james.apache.org/rfc1766", "Content-Language");
    }

    public List<Property> toProperties() {
        return new ArrayList<Property>((Collection<Property>)this.properties);
    }

    public final boolean equals(Object o) {
        if (o instanceof Properties) {
            Properties that = (Properties)o;
            return Objects.equals(this.textualLineCount, that.textualLineCount) && Objects.equals(this.properties, that.properties);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.textualLineCount, this.properties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("textualLineCount", (Object)this.textualLineCount).add("properties", this.properties).toString();
    }
}

