/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.BlobManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.BlobNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.Blob;
import org.apache.james.mailbox.model.BlobId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;

public class StoreBlobManager
implements BlobManager {
    public static final ContentType MESSAGE_RFC822_CONTENT_TYPE = ContentType.of((String)"message/rfc822");
    private final AttachmentManager attachmentManager;
    private final MessageIdManager messageIdManager;
    private final MessageId.Factory messageIdFactory;

    @Inject
    public StoreBlobManager(AttachmentManager attachmentManager, MessageIdManager messageIdManager, MessageId.Factory messageIdFactory) {
        this.attachmentManager = attachmentManager;
        this.messageIdManager = messageIdManager;
        this.messageIdFactory = messageIdFactory;
    }

    public BlobId toBlobId(MessageId messageId) {
        return BlobId.fromString((String)messageId.serialize());
    }

    public Blob retrieve(BlobId blobId, MailboxSession mailboxSession) throws MailboxException, BlobNotFoundException {
        return this.getBlobFromAttachment(blobId, mailboxSession).orElseGet(() -> this.getBlobFromMessage(blobId, mailboxSession).orElseThrow(() -> new BlobNotFoundException(blobId)));
    }

    private Optional<Blob> getBlobFromAttachment(BlobId blobId, MailboxSession mailboxSession) throws MailboxException {
        try {
            AttachmentId attachmentId = AttachmentId.from((BlobId)blobId);
            AttachmentMetadata attachment = this.attachmentManager.getAttachment(attachmentId, mailboxSession);
            Blob blob = Blob.builder().id(blobId).payload(() -> {
                try {
                    return this.attachmentManager.loadAttachmentContent(attachmentId, mailboxSession);
                }
                catch (AttachmentNotFoundException e) {
                    throw new BlobNotFoundException(blobId, (Throwable)e);
                }
            }).size(attachment.getSize()).contentType(attachment.getType()).build();
            return Optional.of(blob);
        }
        catch (AttachmentNotFoundException e) {
            return Optional.empty();
        }
    }

    private Optional<Blob> getBlobFromMessage(BlobId blobId, MailboxSession mailboxSession) {
        return this.retrieveMessageId(blobId).flatMap(messageId -> this.loadMessageAsInputStream((MessageId)messageId, mailboxSession)).map(Throwing.function(content -> Blob.builder().id(blobId).contentType(MESSAGE_RFC822_CONTENT_TYPE).size(content.size()).payload(() -> ((Content)content).getInputStream()).build()));
    }

    private Optional<MessageId> retrieveMessageId(BlobId blobId) {
        try {
            return Optional.of(this.messageIdFactory.fromString(blobId.asString()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private Optional<Content> loadMessageAsInputStream(MessageId messageId, MailboxSession mailboxSession) {
        try {
            return this.messageIdManager.getMessage(messageId, FetchGroup.FULL_CONTENT, mailboxSession).stream().map(Throwing.function(MessageResult::getFullContent)).findFirst();
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

