/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.jmx.MailSpoolerMBean;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JamesMailSpooler
implements org.apache.james.lifecycle.api.Disposable,
Configurable,
MailSpoolerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesMailSpooler.class);
    public static final String SPOOL_PROCESSING = "spoolProcessing";
    public static final AttributeName MAIL_PROCESSING_ERROR_COUNT = AttributeName.of((String)"mail-processing-error-count");
    public static final MailRepositoryPath ERROR_REPOSITORY_PATH = MailRepositoryPath.from((String)"var/mail/error");
    public static final int MAXIMUM_FAILURE_COUNT = 5;
    private final MetricFactory metricFactory;
    private final MailProcessor mailProcessor;
    private final MailRepositoryStore mailRepositoryStore;
    private final MailQueueFactory<?> queueFactory;
    private Configuration configuration;
    private Optional<Runner> runner;

    @Inject
    public JamesMailSpooler(MetricFactory metricFactory, MailProcessor mailProcessor, MailRepositoryStore mailRepositoryStore, MailQueueFactory<?> queueFactory) {
        this.metricFactory = metricFactory;
        this.mailProcessor = mailProcessor;
        this.mailRepositoryStore = mailRepositoryStore;
        this.queueFactory = queueFactory;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.configure(Configuration.from(this.mailRepositoryStore, config));
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    @PostConstruct
    public void init() {
        if (this.configuration.isEnabled()) {
            LOGGER.info("init...");
            LOGGER.info("Concurrency level is {}", (Object)this.configuration.getConcurrencyLevel());
            MailQueue queue = this.queueFactory.createQueue(MailQueueFactory.SPOOL, MailQueueFactory.prefetchCount((int)this.configuration.getConcurrencyLevel()));
            this.runner = Optional.of(new Runner(this.metricFactory, this.mailProcessor, this.errorRepository(), queue, this.configuration));
            LOGGER.info("Spooler started");
        } else {
            LOGGER.info("Spooler had been deactivated. To enable it set 'threads' count to a value greater than zero");
        }
    }

    private MailRepository errorRepository() {
        try {
            return this.mailRepositoryStore.select(this.configuration.getErrorRepositoryURL());
        }
        catch (MailRepositoryStore.MailRepositoryStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void dispose() {
        this.runner.ifPresent(Runner::dispose);
    }

    public int getThreadCount() {
        return this.configuration.getConcurrencyLevel();
    }

    public int getCurrentSpoolCount() {
        return this.runner.map(Runner::getCurrentSpoolCount).orElse(0);
    }

    public static class Configuration {
        private final int concurrencyLevel;
        private final MailRepositoryUrl errorRepositoryURL;

        public static Configuration from(MailRepositoryStore mailRepositoryStore, HierarchicalConfiguration<ImmutableNode> config) {
            int concurrencyLevel = config.getInt("threads", 100);
            MailRepositoryUrl errorRepositoryURL = Optional.ofNullable(config.getString("errorRepository", null)).map(MailRepositoryUrl::from).orElseGet(() -> MailRepositoryUrl.fromPathAndProtocol((Protocol)((Protocol)mailRepositoryStore.defaultProtocol().orElseThrow(() -> new IllegalStateException("Cannot retrieve mailRepository URL, you need to configure an `errorRepository` property for the spooler.0"))), (MailRepositoryPath)ERROR_REPOSITORY_PATH));
            return new Configuration(concurrencyLevel, errorRepositoryURL);
        }

        public Configuration(int concurrencyLevel, MailRepositoryUrl errorRepositoryURL) {
            Preconditions.checkArgument((concurrencyLevel >= 0 ? 1 : 0) != 0, (Object)"'threads' needs to be greater than or equal to zero");
            this.concurrencyLevel = concurrencyLevel;
            this.errorRepositoryURL = errorRepositoryURL;
        }

        public int getConcurrencyLevel() {
            return this.concurrencyLevel;
        }

        public boolean isEnabled() {
            return this.concurrencyLevel > 0;
        }

        public MailRepositoryUrl getErrorRepositoryURL() {
            return this.errorRepositoryURL;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("concurrencyLevel", this.concurrencyLevel).add("errorRepositoryURL", (Object)this.errorRepositoryURL).toString();
        }
    }

    private static class Runner {
        private final AtomicInteger processingActive = new AtomicInteger(0);
        private final MetricFactory metricFactory;
        private final MailProcessor mailProcessor;
        private final MailRepository errorRepository;
        private final Disposable disposable;
        private final MailQueue queue;
        private final Configuration configuration;

        private Runner(MetricFactory metricFactory, MailProcessor mailProcessor, MailRepository errorRepository, MailQueue queue, Configuration configuration) {
            this.metricFactory = metricFactory;
            this.mailProcessor = mailProcessor;
            this.errorRepository = errorRepository;
            this.queue = queue;
            this.configuration = configuration;
            this.disposable = this.run(queue);
        }

        private Disposable run(MailQueue queue) {
            return Flux.from((Publisher)queue.deQueue()).flatMap(item -> this.handleOnQueueItem((MailQueue.MailQueueItem)item).subscribeOn(Schedulers.elastic()), this.configuration.getConcurrencyLevel()).onErrorContinue((throwable, item) -> LOGGER.error("Exception processing mail while spooling {}", item, throwable)).subscribeOn(Schedulers.elastic()).subscribe();
        }

        private Mono<Void> handleOnQueueItem(MailQueue.MailQueueItem queueItem) {
            TimeMetric timeMetric = this.metricFactory.timer(JamesMailSpooler.SPOOL_PROCESSING);
            return Mono.fromCallable(this.processingActive::incrementAndGet).flatMap(ignore -> this.processMail(queueItem)).doOnSuccess(any -> timeMetric.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD)).doOnTerminate(this.processingActive::decrementAndGet);
        }

        private Mono<Void> processMail(MailQueue.MailQueueItem queueItem) {
            return Mono.using(() -> ((MailQueue.MailQueueItem)queueItem).getMail(), mail -> Mono.fromRunnable(() -> this.performProcessMail(queueItem, (Mail)mail)), LifecycleUtil::dispose);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performProcessMail(MailQueue.MailQueueItem queueItem, Mail mail) {
            LOGGER.debug("==== Begin processing mail {} ====", (Object)mail.getName());
            try {
                this.mailProcessor.service(mail);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Thread has been interrupted");
                }
                queueItem.done(true);
            }
            catch (Exception e) {
                this.handleError(queueItem, mail, e);
            }
            finally {
                LOGGER.debug("==== End processing mail {} ====", (Object)mail.getName());
            }
        }

        private void handleError(MailQueue.MailQueueItem queueItem, Mail mail, Exception processingException) {
            int failureCount = this.computeFailureCount(mail);
            try {
                if (failureCount > 5) {
                    LOGGER.error("Failed {} processing {} consecutive times. Abort. Mail is saved in {}", new Object[]{mail.getName(), failureCount, this.configuration.getErrorRepositoryURL().asString()});
                    this.storeInErrorRepository(queueItem);
                } else {
                    LOGGER.error("Failed {} processing {} consecutive times. Mail is requeued with increased failure count.", new Object[]{mail.getName(), failureCount, processingException});
                    this.reEnqueue(queueItem, failureCount);
                }
            }
            catch (Exception nestedE) {
                LOGGER.error("Could not apply standard error handling for {}, defaulting to nack", (Object)mail.getName(), (Object)nestedE);
                this.nack(queueItem, processingException);
            }
        }

        private int computeFailureCount(Mail mail) {
            Integer previousFailureCount = mail.getAttribute(MAIL_PROCESSING_ERROR_COUNT).flatMap(attribute -> attribute.getValue().valueAs(Integer.class)).orElse(0);
            return previousFailureCount + 1;
        }

        private void reEnqueue(MailQueue.MailQueueItem queueItem, int failureCount) throws MailQueue.MailQueueException {
            Mail mail = queueItem.getMail();
            mail.setAttribute(new Attribute(MAIL_PROCESSING_ERROR_COUNT, AttributeValue.of((Integer)failureCount)));
            this.queue.enQueue(mail);
            queueItem.done(true);
        }

        private void storeInErrorRepository(MailQueue.MailQueueItem queueItem) throws MessagingException {
            this.errorRepository.store(queueItem.getMail());
            queueItem.done(true);
        }

        private void nack(MailQueue.MailQueueItem queueItem, Exception processingException) {
            try {
                queueItem.done(false);
            }
            catch (MailQueue.MailQueueException ex) {
                throw new RuntimeException(processingException);
            }
        }

        public void dispose() {
            LOGGER.info("start dispose() ...");
            this.disposable.dispose();
            try {
                this.queue.close();
            }
            catch (IOException e) {
                LOGGER.debug("error closing queue", (Throwable)e);
            }
            LOGGER.info("thread shutdown completed.");
        }

        public int getCurrentSpoolCount() {
            return this.processingActive.get();
        }
    }
}

