/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.ExpungeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpungeProcessor
extends AbstractMailboxProcessor<ExpungeRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpungeProcessor.class);
    private static final List<Capability> UIDPLUS = ImmutableList.of((Object)ImapConstants.SUPPORTS_UIDPLUS);

    public ExpungeProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(ExpungeRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(ExpungeRequest request, ImapSession session, ImapProcessor.Responder responder) {
        try {
            MessageManager mailbox = this.getSelectedMailbox(session).orElseThrow(() -> new MailboxException("Session not in SELECTED state"));
            MailboxSession mailboxSession = session.getMailboxSession();
            int expunged = 0;
            MessageManager.MailboxMetaData mdata = mailbox.getMetaData(false, mailboxSession, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT);
            if (!mdata.isWriteable()) {
                this.no(request, responder, HumanReadableText.MAILBOX_IS_READ_ONLY);
            } else {
                IdRange[] ranges = request.getUidSet();
                if (ranges == null) {
                    expunged = this.expunge(mailbox, MessageRange.all(), session, mailboxSession);
                } else {
                    for (IdRange range : ranges) {
                        MessageRange mRange = this.messageRange(session.getSelected(), range, true);
                        if (mRange == null) continue;
                        expunged += this.expunge(mailbox, mRange, session, mailboxSession);
                    }
                }
                this.unsolicitedResponses(session, responder, false);
                if (EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC) && expunged > 0) {
                    this.okComplete(request, StatusResponse.ResponseCode.highestModSeq(mdata.getHighestModSeq()), responder);
                } else {
                    this.okComplete(request, responder);
                }
            }
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Expunge failed", (Throwable)e);
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("Expunge failed for mailbox {}", (Object)session.getSelected().getMailboxId(), (Object)e);
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private int expunge(MessageManager mailbox, MessageRange range, ImapSession session, MailboxSession mailboxSession) throws MailboxException {
        Iterator it = mailbox.expunge(range, mailboxSession);
        SelectedMailbox selected = session.getSelected();
        int expunged = 0;
        if (mailboxSession != null) {
            while (it.hasNext()) {
                MessageUid uid = (MessageUid)it.next();
                selected.removeRecent(uid);
                ++expunged;
            }
        }
        return expunged;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return UIDPLUS;
    }

    @Override
    protected Closeable addContextToMDC(ExpungeRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"EXPUNGE").addContext("uidSet", (Object)IdRange.toString(request.getUidSet())).build();
    }
}

