/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CompressRequest;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.util.MDCBuilder;

public class CompressProcessor
extends AbstractChainedProcessor<CompressRequest>
implements CapabilityImplementingProcessor {
    private static final String ALGO = "DEFLATE";
    private static final List<Capability> CAPA = ImmutableList.of((Object)Capability.of(ImapConstants.COMPRESS_COMMAND.getName() + "=DEFLATE"));
    private final StatusResponseFactory factory;
    private static final String COMPRESSED = "COMPRESSED";

    public CompressProcessor(ImapProcessor next, StatusResponseFactory factory) {
        super(CompressRequest.class, next);
        this.factory = factory;
    }

    @Override
    protected void doProcess(CompressRequest request, ImapProcessor.Responder responder, ImapSession session) {
        if (session.isCompressionSupported()) {
            Object obj = session.getAttribute(COMPRESSED);
            if (obj != null) {
                responder.respond(this.factory.taggedNo(request.getTag(), request.getCommand(), HumanReadableText.COMPRESS_ALREADY_ACTIVE));
            } else if (!request.getAlgorithm().equalsIgnoreCase(ALGO)) {
                responder.respond(this.factory.taggedBad(request.getTag(), request.getCommand(), HumanReadableText.ILLEGAL_ARGUMENTS));
            } else {
                responder.respond(this.factory.taggedOk(request.getTag(), request.getCommand(), HumanReadableText.DEFLATE_ACTIVE));
                if (session.startCompression()) {
                    session.setAttribute(COMPRESSED, true);
                }
            }
        } else {
            responder.respond(this.factory.taggedBad(request.getTag(), request.getCommand(), HumanReadableText.UNKNOWN_COMMAND));
        }
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        if (session.isCompressionSupported()) {
            return CAPA;
        }
        return Collections.emptyList();
    }

    @Override
    protected Closeable addContextToMDC(CompressRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"COMPRESS").addContext("algorithm", (Object)message.getAlgorithm()).build();
    }
}

