/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CapabilityRequest;
import org.apache.james.imap.message.response.CapabilityResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class CapabilityProcessor
extends AbstractMailboxProcessor<CapabilityRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.BASIC_CAPABILITIES, (Object)ImapConstants.SUPPORTS_LITERAL_PLUS, (Object)ImapConstants.SUPPORTS_RFC3348, (Object)ImapConstants.SUPPORTS_I18NLEVEL_1, (Object)ImapConstants.SUPPORTS_CONDSTORE);
    private final List<CapabilityImplementingProcessor> capabilities = new ArrayList<CapabilityImplementingProcessor>();
    private final Set<Capability> disabledCaps = new HashSet<Capability>();

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CapabilityRequest.class, next, mailboxManager, factory, metricFactory);
        this.capabilities.add(this);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.disabledCaps.addAll((Collection<Capability>)imapConfiguration.getDisabledCaps());
        if (this.shouldDisableCondstore(imapConfiguration)) {
            this.disabledCaps.add(ImapConstants.SUPPORTS_CONDSTORE);
        }
    }

    private boolean shouldDisableCondstore(ImapConfiguration imapConfiguration) {
        return !imapConfiguration.isCondstoreEnable() && !this.disabledCaps.contains(ImapConstants.SUPPORTS_CONDSTORE);
    }

    @Override
    protected void processRequest(CapabilityRequest request, ImapSession session, ImapProcessor.Responder responder) {
        CapabilityResponse result = new CapabilityResponse(this.getSupportedCapabilities(session));
        responder.respond(result);
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(request, responder);
    }

    public void addProcessor(CapabilityImplementingProcessor implementor) {
        this.capabilities.add(implementor);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    public Set<Capability> getSupportedCapabilities(ImapSession session) {
        HashSet<Capability> caps = new HashSet<Capability>();
        for (CapabilityImplementingProcessor capability : this.capabilities) {
            caps.addAll(capability.getImplementedCapabilities(session));
        }
        caps.removeAll(this.disabledCaps);
        return caps;
    }

    @Override
    protected Closeable addContextToMDC(CapabilityRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"CAPABILITY").build();
    }
}

