/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;

public class JsonGenericSerializer<T, U extends DTO> {
    private final ObjectMapper objectMapper;
    private final DTOConverter<T, U> dtoConverter;

    public static <T, U extends DTO> RequireNestedConfiguration<T, U> forModules(Set<? extends DTOModule<? extends T, ? extends U>> modules) {
        return nestedTypesModules -> {
            ImmutableSet dtoModules = ImmutableSet.copyOf((Collection)modules);
            return new JsonGenericSerializer(dtoModules, (Set<? extends DTOModule<?, ?>>)((Set<DTOModule<?, ?>>)ImmutableSet.copyOf((Collection)nestedTypesModules)), new DTOConverter(dtoModules));
        };
    }

    @SafeVarargs
    public static <T, U extends DTO> RequireNestedConfiguration<T, U> forModules(DTOModule<? extends T, ? extends U> ... modules) {
        return JsonGenericSerializer.forModules(ImmutableSet.copyOf((Object[])modules));
    }

    private JsonGenericSerializer(Set<? extends DTOModule<? extends T, ? extends U>> modules, Set<? extends DTOModule<?, ?>> nestedTypesModules, DTOConverter<T, U> converter) {
        Preconditions.checkArgument((!this.hasDuplicateTypeIds(modules, nestedTypesModules) ? 1 : 0) != 0);
        this.dtoConverter = converter;
        this.objectMapper = this.buildObjectMapper((Set<? extends DTOModule<?, ?>>)Sets.union(modules, nestedTypesModules));
    }

    private boolean hasDuplicateTypeIds(Set<? extends DTOModule<?, ?>> modules, Set<? extends DTOModule<?, ?>> nestedTypesModules) {
        return Sets.intersection(modules.stream().map(DTOModule::getDomainObjectType).collect(Collectors.toSet()), nestedTypesModules.stream().map(DTOModule::getDomainObjectType).collect(Collectors.toSet())).size() > 0;
    }

    private ObjectMapper buildObjectMapper(Set<? extends DTOModule<?, ?>> modules) {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        NamedType[] namedTypes = (NamedType[])modules.stream().map(module -> new NamedType(module.getDTOClass(), module.getDomainObjectType())).toArray(NamedType[]::new);
        objectMapper.registerSubtypes(namedTypes);
        return objectMapper;
    }

    public String serialize(T domainObject) throws JsonProcessingException {
        DTO dto = (DTO)this.dtoConverter.toDTO(domainObject).orElseThrow(() -> new UnknownTypeException("unknown type " + domainObject.getClass()));
        return this.objectMapper.writeValueAsString((Object)dto);
    }

    public T deserialize(String value) throws IOException {
        Object dto = this.jsonToDTO(value);
        return this.dtoConverter.toDomainObject(dto).orElseThrow(() -> new UnknownTypeException("unknown type " + dto.getType()));
    }

    private U jsonToDTO(String value) throws IOException {
        try {
            JsonNode jsonTree = this.detectDuplicateProperty(value);
            return this.parseAsPolymorphicDTO(jsonTree);
        }
        catch (InvalidTypeIdException e) {
            String typeId = e.getTypeId();
            if (typeId == null) {
                throw new InvalidTypeException("Unable to deserialize the json document", (MismatchedInputException)((Object)e));
            }
            throw new UnknownTypeException("unknown type " + typeId);
        }
        catch (MismatchedInputException e) {
            throw new InvalidTypeException("Unable to deserialize the json document", e);
        }
    }

    private JsonNode detectDuplicateProperty(String value) throws IOException {
        return this.objectMapper.readTree(value);
    }

    private U parseAsPolymorphicDTO(JsonNode jsonTree) throws IOException {
        return (U)((DTO)this.objectMapper.readValue(this.objectMapper.treeAsTokens((TreeNode)jsonTree), DTO.class));
    }

    public static class UnknownTypeException
    extends RuntimeException {
        public UnknownTypeException(String message) {
            super(message);
        }
    }

    public static class InvalidTypeException
    extends RuntimeException {
        public InvalidTypeException(String message) {
            super(message);
        }

        public InvalidTypeException(String message, MismatchedInputException exception) {
            super(message, (Throwable)exception);
        }
    }

    public static interface RequireNestedConfiguration<T, U extends DTO> {
        public JsonGenericSerializer<T, U> withNestedTypeModules(Set<DTOModule<?, ?>> var1);

        default public JsonGenericSerializer<T, U> withMultipleNestedTypeModules(DTOModule<?, ?> ... modules) {
            return this.withNestedTypeModules((Set<DTOModule<?, ?>>)ImmutableSet.copyOf((Object[])modules));
        }

        default public JsonGenericSerializer<T, U> withMultipleNestedTypeModules(Set<DTOModule<?, ?>> ... modules) {
            return this.withNestedTypeModules((Set)Arrays.stream(modules).flatMap(Collection::stream).collect(Guavate.toImmutableSet()));
        }

        default public JsonGenericSerializer<T, U> withoutNestedType() {
            return this.withNestedTypeModules((Set<DTOModule<?, ?>>)ImmutableSet.of());
        }
    }
}

