/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.james.core.Username;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyLDAPUser;
import org.apache.james.user.ldap.retry.DoublingRetrySchedule;
import org.apache.james.user.ldap.retry.api.RetrySchedule;
import org.apache.james.user.ldap.retry.naming.ldap.RetryingLdapContext;
import org.apache.james.user.lib.UsersDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyLDAPUsersDAO
implements UsersDAO,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyLDAPUsersDAO.class);
    private static final String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String PROPERTY_NAME_CONNECTION_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String PROPERTY_NAME_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String PROPERTY_NAME_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private LdapContext ldapContext;
    private RetrySchedule schedule = null;
    private LdapRepositoryConfiguration ldapConfiguration;

    @Inject
    public ReadOnlyLDAPUsersDAO() {
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        this.configure(LdapRepositoryConfiguration.from(configuration));
    }

    public void configure(LdapRepositoryConfiguration configuration) {
        this.ldapConfiguration = configuration;
        this.schedule = new DoublingRetrySchedule(configuration.getRetryStartInterval(), configuration.getRetryMaxInterval(), configuration.getScale());
    }

    public void init() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getClass().getName() + ".init()\nLDAP host: " + this.ldapConfiguration.getLdapHost() + "\nUser baseDN: " + this.ldapConfiguration.getUserBase() + "\nuserIdAttribute: " + this.ldapConfiguration.getUserIdAttribute() + "\nGroup restriction: " + this.ldapConfiguration.getRestriction() + "\nUseConnectionPool: " + this.ldapConfiguration.useConnectionPool() + "\nconnectionTimeout: " + this.ldapConfiguration.getConnectionTimeout() + "\nreadTimeout: " + this.ldapConfiguration.getReadTimeout() + "\nretrySchedule: " + this.schedule + "\nmaxRetries: " + this.ldapConfiguration.getMaxRetries() + "\n");
        }
        this.updateLdapContext();
    }

    protected void updateLdapContext() throws NamingException {
        this.ldapContext = this.computeLdapContext();
    }

    protected LdapContext computeLdapContext() throws NamingException {
        return new RetryingLdapContext(this.schedule, this.ldapConfiguration.getMaxRetries()){

            @Override
            public Context newDelegate() throws NamingException {
                return new InitialLdapContext(ReadOnlyLDAPUsersDAO.this.getContextEnvironment(), null);
            }
        };
    }

    protected Properties getContextEnvironment() {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        props.put("java.naming.provider.url", Optional.ofNullable(this.ldapConfiguration.getLdapHost()).orElse(""));
        if (Strings.isNullOrEmpty((String)this.ldapConfiguration.getCredentials())) {
            props.put("java.naming.security.authentication", "none");
        } else {
            props.put("java.naming.security.authentication", "simple");
            props.put("java.naming.security.principal", Optional.ofNullable(this.ldapConfiguration.getPrincipal()).orElse(""));
            props.put("java.naming.security.credentials", this.ldapConfiguration.getCredentials());
        }
        props.put(PROPERTY_NAME_CONNECTION_POOL, String.valueOf(this.ldapConfiguration.useConnectionPool()));
        if (this.ldapConfiguration.getConnectionTimeout() > -1) {
            props.put(PROPERTY_NAME_CONNECT_TIMEOUT, String.valueOf(this.ldapConfiguration.getConnectionTimeout()));
        }
        if (this.ldapConfiguration.getReadTimeout() > -1) {
            props.put(PROPERTY_NAME_READ_TIMEOUT, Integer.toString(this.ldapConfiguration.getReadTimeout()));
        }
        return props;
    }

    private boolean userInGroupsMembershipList(String userDN, Map<String, Collection<String>> groupMembershipList) {
        boolean result = false;
        Collection<Collection<String>> memberLists = groupMembershipList.values();
        Iterator<Collection<String>> memberListsIterator = memberLists.iterator();
        while (memberListsIterator.hasNext() && !result) {
            Collection<String> groupMembers = memberListsIterator.next();
            result = groupMembers.contains(userDN);
        }
        return result;
    }

    private Set<String> getAllUsersFromLDAP() throws NamingException {
        HashSet<String> result = new HashSet<String>();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{"distinguishedName"});
        NamingEnumeration<SearchResult> sr = this.ldapContext.search(this.ldapConfiguration.getUserBase(), "(objectClass=" + this.ldapConfiguration.getUserObjectClass() + ")", sc);
        while (sr.hasMore()) {
            SearchResult r = sr.next();
            result.add(r.getNameInNamespace());
        }
        return result;
    }

    private Collection<ReadOnlyLDAPUser> buildUserCollection(Collection<String> userDNs) throws NamingException {
        ArrayList<ReadOnlyLDAPUser> results = new ArrayList<ReadOnlyLDAPUser>();
        for (String userDN : userDNs) {
            Optional<ReadOnlyLDAPUser> user = this.buildUser(userDN);
            user.ifPresent(results::add);
        }
        return results;
    }

    private ReadOnlyLDAPUser searchAndBuildUser(Username name) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{this.ldapConfiguration.getUserIdAttribute()});
        sc.setCountLimit(1L);
        String filterTemplate = "(&({0}={1})(objectClass={2})" + StringUtils.defaultString((String)this.ldapConfiguration.getFilter(), (String)"") + ")";
        String sanitizedFilter = FilterEncoder.format((String)filterTemplate, (String[])new String[]{this.ldapConfiguration.getUserIdAttribute(), name.asString(), this.ldapConfiguration.getUserObjectClass()});
        NamingEnumeration<SearchResult> sr = this.ldapContext.search(this.ldapConfiguration.getUserBase(), sanitizedFilter, sc);
        if (!sr.hasMore()) {
            return null;
        }
        SearchResult r = sr.next();
        Attribute userName = r.getAttributes().get(this.ldapConfiguration.getUserIdAttribute());
        if (!this.ldapConfiguration.getRestriction().isActivated() || this.userInGroupsMembershipList(r.getNameInNamespace(), this.ldapConfiguration.getRestriction().getGroupMembershipLists(this.ldapContext))) {
            return new ReadOnlyLDAPUser(Username.of((String)userName.get().toString()), r.getNameInNamespace(), this.ldapContext);
        }
        return null;
    }

    private Optional<ReadOnlyLDAPUser> buildUser(String userDN) throws NamingException {
        Attributes userAttributes = this.ldapContext.getAttributes(userDN);
        Optional<Attribute> userName = Optional.ofNullable(userAttributes.get(this.ldapConfiguration.getUserIdAttribute()));
        return userName.map(Throwing.function(u -> u.get().toString()).sneakyThrow()).map(Username::of).map(username -> new ReadOnlyLDAPUser((Username)username, userDN, this.ldapContext));
    }

    public boolean contains(Username name) throws UsersRepositoryException {
        return this.getUserByName(name).isPresent();
    }

    public int countUsers() throws UsersRepositoryException {
        try {
            return Math.toIntExact(this.getValidUsers().stream().map(Throwing.function(this::buildUser).sneakyThrow()).flatMap(Optional::stream).count());
        }
        catch (NamingException e) {
            throw new UsersRepositoryException("Unable to retrieve user count from ldap", (Throwable)e);
        }
    }

    public Optional<User> getUserByName(Username name) throws UsersRepositoryException {
        try {
            return Optional.ofNullable(this.searchAndBuildUser(name));
        }
        catch (NamingException e) {
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
    }

    public Iterator<Username> list() throws UsersRepositoryException {
        try {
            return ((ImmutableList)this.buildUserCollection(this.getValidUsers()).stream().map(ReadOnlyLDAPUser::getUserName).collect(Guavate.toImmutableList())).iterator();
        }
        catch (NamingException namingException) {
            throw new UsersRepositoryException("Unable to retrieve users list from LDAP due to unknown naming error.", (Throwable)namingException);
        }
    }

    private Collection<String> getValidUsers() throws NamingException {
        Collection<String> validUserDNs;
        Set<String> userDNs = this.getAllUsersFromLDAP();
        if (this.ldapConfiguration.getRestriction().isActivated()) {
            Map<String, Collection<String>> groupMembershipList = this.ldapConfiguration.getRestriction().getGroupMembershipLists(this.ldapContext);
            validUserDNs = new ArrayList();
            for (String userDN : userDNs) {
                if (!this.userInGroupsMembershipList(userDN, groupMembershipList)) continue;
                validUserDNs.add(userDN);
            }
        } else {
            validUserDNs = userDNs;
        }
        return validUserDNs;
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void updateUser(User user) throws UsersRepositoryException {
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void addUser(Username username, String password) throws UsersRepositoryException {
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }
}

