/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.language.DatasonnetExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.util.ObjectHelper;

public abstract class BuilderSupport {
    private CamelContext context;
    private ErrorHandlerBuilder errorHandlerBuilder;

    protected BuilderSupport() {
    }

    protected BuilderSupport(CamelContext context) {
        this.context = context;
    }

    public ValueBuilder header(String name) {
        HeaderExpression exp = new HeaderExpression(name);
        return new ValueBuilder(exp);
    }

    public ValueBuilder exchangeProperty(String name) {
        ExchangePropertyExpression exp = new ExchangePropertyExpression(name);
        return new ValueBuilder(exp);
    }

    public ValueBuilder body() {
        return Builder.body();
    }

    public <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public ValueBuilder systemProperty(String name) {
        return Builder.systemProperty(name);
    }

    public ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty(name, defaultValue);
    }

    public ValueBuilder constant(Object value) {
        return Builder.constant(value);
    }

    public ValueBuilder joor(String value) {
        return Builder.joor(value);
    }

    public ValueBuilder joor(String value, Class<?> resultType) {
        return Builder.joor(value, resultType);
    }

    public ValueBuilder jsonpath(String value) {
        return Builder.jsonpath(value);
    }

    public ValueBuilder jsonpath(String value, Class<?> resultType) {
        return Builder.jsonpath(value, resultType);
    }

    public ValueBuilder csimple(String value) {
        return Builder.csimple(value);
    }

    public ValueBuilder csimple(String value, Class<?> resultType) {
        return Builder.csimple(value, resultType);
    }

    public ValueBuilder datasonnet(String value) {
        DatasonnetExpression exp = new DatasonnetExpression(value);
        return new ValueBuilder(exp);
    }

    public ValueBuilder datasonnet(Expression value) {
        DatasonnetExpression exp = new DatasonnetExpression(value);
        return new ValueBuilder(exp);
    }

    public ValueBuilder datasonnet(String value, Class<?> resultType) {
        DatasonnetExpression exp = new DatasonnetExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public ValueBuilder datasonnet(Expression value, Class<?> resultType) {
        DatasonnetExpression exp = new DatasonnetExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public SimpleBuilder simple(String value) {
        return SimpleBuilder.simple(value);
    }

    public SimpleBuilder simple(String value, Class<?> resultType) {
        return SimpleBuilder.simple(value, resultType);
    }

    public SimpleBuilder simpleF(String format, Object ... values) {
        return SimpleBuilder.simpleF(format, values);
    }

    public SimpleBuilder simpleF(String format, Class<?> resultType, Object ... values) {
        return SimpleBuilder.simpleF(format, resultType, values);
    }

    public ValueBuilder xpath(String value) {
        return this.xpath(value, null, null);
    }

    public ValueBuilder xpath(String value, Class<?> resultType) {
        return this.xpath(value, resultType, null);
    }

    public ValueBuilder xpath(String value, Namespaces namespaces) {
        return this.xpath(value, null, namespaces);
    }

    public ValueBuilder xpath(String value, Class<?> resultType, Namespaces namespaces) {
        try {
            value = this.getContext().resolvePropertyPlaceholders(value);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        XPathExpression exp = new XPathExpression(value);
        exp.setResultType(resultType);
        if (namespaces != null) {
            exp.setNamespaces(namespaces.getNamespaces());
        }
        return new ValueBuilder(exp);
    }

    public ValueBuilder method(Object beanOrBeanRef) {
        return this.method(beanOrBeanRef, null);
    }

    public ValueBuilder method(Object beanOrBeanRef, String method) {
        return Builder.method(beanOrBeanRef, method);
    }

    public ValueBuilder method(Class<?> beanType) {
        return Builder.method(beanType);
    }

    public ValueBuilder method(Class<?> beanType, String method) {
        return Builder.bean(beanType, method);
    }

    public ValueBuilder regexReplaceAll(Expression content, String regex, String replacement) {
        return Builder.regexReplaceAll(content, regex, replacement);
    }

    public ValueBuilder regexReplaceAll(Expression content, String regex, Expression replacement) {
        return Builder.regexReplaceAll(content, regex, replacement);
    }

    public ValueBuilder exceptionMessage() {
        return Builder.exceptionMessage();
    }

    public Endpoint endpoint(String uri) throws NoSuchEndpointException {
        ObjectHelper.notNull((Object)uri, (String)"uri");
        Endpoint endpoint = this.getContext().getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public <T extends Endpoint> T endpoint(String uri, Class<T> type) throws NoSuchEndpointException {
        ObjectHelper.notNull((Object)uri, (String)"uri");
        Endpoint endpoint = this.getContext().getEndpoint(uri, type);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return (T)endpoint;
    }

    public List<Endpoint> endpoints(String ... uris) throws NoSuchEndpointException {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (String uri : uris) {
            endpoints.add(this.endpoint(uri));
        }
        return endpoints;
    }

    public List<Endpoint> endpoints(Endpoint ... endpoints) {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        answer.addAll(Arrays.asList(endpoints));
        return answer;
    }

    public DefaultErrorHandlerBuilder defaultErrorHandler() {
        return new DefaultErrorHandlerBuilder();
    }

    public NoErrorHandlerBuilder noErrorHandler() {
        return new NoErrorHandlerBuilder();
    }

    public DeadLetterChannelBuilder deadLetterChannel(String deadLetterUri) {
        return this.deadLetterChannel(this.endpoint(deadLetterUri));
    }

    public DeadLetterChannelBuilder deadLetterChannel(Endpoint deadLetterEndpoint) {
        return new DeadLetterChannelBuilder(deadLetterEndpoint);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public void setContext(CamelContext context) {
        ObjectHelper.notNull((Object)context, (String)"CamelContext", (Object)this);
        this.context = context;
    }

    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        return new DefaultErrorHandlerBuilder();
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }
}

