/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class RemoteDeliverySocketFactory
extends SocketFactory {
    private static InetAddress bindAddress;

    public static void setBindAdress(String addr) throws UnknownHostException {
        bindAddress = addr == null ? null : InetAddress.getByName(addr);
    }

    public static SocketFactory getDefault() {
        return new RemoteDeliverySocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket s = new Socket();
        s.bind(new InetSocketAddress(bindAddress, 0));
        return s;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port, bindAddress, 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return new Socket(host, port, clientHost == null ? bindAddress : clientHost, clientPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return new Socket(host, port, bindAddress, 0);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return new Socket(address, port, clientAddress == null ? bindAddress : clientAddress, clientPort);
    }
}

