/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.Closeable;
import java.util.Optional;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;

public class SMTPMDCContextFactory
implements ProtocolMDCContextFactory {
    public Closeable from(Protocol protocol, ChannelHandlerContext ctx) {
        return MDCBuilder.create().addContext(ProtocolMDCContextFactory.mdcContext((Protocol)protocol, (ChannelHandlerContext)ctx)).addContext(this.from(ctx.getAttachment())).build();
    }

    public static MDCBuilder forSession(SMTPSession smtpSession) {
        return MDCBuilder.create().addContext(ProtocolMDCContextFactory.forSession((ProtocolSession)smtpSession)).addContext(SMTPMDCContextFactory.forSMTPSession(smtpSession));
    }

    private MDCBuilder from(Object o) {
        return Optional.ofNullable(o).filter(object -> object instanceof SMTPSession).map(object -> (SMTPSession)object).map(SMTPMDCContextFactory::forSMTPSession).orElse(MDCBuilder.create());
    }

    private static MDCBuilder forSMTPSession(SMTPSession smtpSession) {
        return MDCBuilder.create().addContext("ehlo", (Object)smtpSession.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection)).addContext("sender", smtpSession.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).map(MaybeSender::asString)).addContext("recipients", (Object)smtpSession.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction));
    }
}

