/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTask;
import org.apache.mailbox.tools.indexer.FullReindexingTask;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;

public class ReprocessingContextInformationDTO
implements AdditionalInformationDTO {
    protected final String type;
    protected final int successfullyReprocessedMailCount;
    protected final int failedReprocessedMailCount;
    protected final List<ReindexingFailureDTO> messageFailures;
    protected final Optional<List<String>> mailboxFailures;
    protected final Instant timestamp;
    protected final Optional<RunningOptionsDTO> runningOptions;

    static ReIndexingExecutionFailures deserializeFailures(MailboxId.Factory mailboxIdFactory, List<ReindexingFailureDTO> failures, List<String> mailboxFailures) {
        List reIndexingFailures = (List)failures.stream().flatMap(failuresForMailbox -> ReprocessingContextInformationDTO.getReIndexingFailureStream(mailboxIdFactory, failuresForMailbox)).collect(Guavate.toImmutableList());
        return new ReIndexingExecutionFailures(reIndexingFailures, (List)mailboxFailures.stream().map(arg_0 -> ((MailboxId.Factory)mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableList()));
    }

    private static Stream<ReIndexingExecutionFailures.ReIndexingFailure> getReIndexingFailureStream(MailboxId.Factory mailboxIdFactory, ReindexingFailureDTO failuresForMailbox) {
        return failuresForMailbox.uids.stream().map(uid -> new ReIndexingExecutionFailures.ReIndexingFailure(mailboxIdFactory.fromString(failuresForMailbox.mailboxId), MessageUid.of((long)uid)));
    }

    static List<ReindexingFailureDTO> serializeFailures(ReIndexingExecutionFailures failures) {
        ImmutableListMultimap failuresByMailbox = (ImmutableListMultimap)failures.messageFailures().stream().collect(Guavate.toImmutableListMultimap(ReIndexingExecutionFailures.ReIndexingFailure::getMailboxId));
        return (List)failuresByMailbox.asMap().entrySet().stream().map(failureByMailbox -> new ReindexingFailureDTO(((MailboxId)failureByMailbox.getKey()).serialize(), (List<Long>)ReprocessingContextInformationDTO.extractMessageUidsFromFailure(failureByMailbox))).collect(Guavate.toImmutableList());
    }

    private static ImmutableList<Long> extractMessageUidsFromFailure(Map.Entry<MailboxId, Collection<ReIndexingExecutionFailures.ReIndexingFailure>> failureByMailbox) {
        return (ImmutableList)failureByMailbox.getValue().stream().map(failure -> failure.getUid().asLong()).collect(Guavate.toImmutableList());
    }

    static List<ReindexingFailureDTO> resolveFailure(Optional<List<ReindexingFailureDTO>> failures, Optional<List<ReindexingFailureDTO>> messageFailures) {
        Preconditions.checkState((boolean)(failures.isPresent() ^ messageFailures.isPresent()), (Object)"Exactly one field 'failures' or 'messageFailures' need to be specified");
        return failures.orElseGet(messageFailures::get);
    }

    ReprocessingContextInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") Optional<List<ReindexingFailureDTO>> failures, @JsonProperty(value="messageFailures") Optional<List<ReindexingFailureDTO>> messageFailures, @JsonProperty(value="mailboxFailures") Optional<List<String>> mailboxFailures, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.type = type;
        this.successfullyReprocessedMailCount = successfullyReprocessedMailCount;
        this.failedReprocessedMailCount = failedReprocessedMailCount;
        this.messageFailures = ReprocessingContextInformationDTO.resolveFailure(failures, messageFailures);
        this.mailboxFailures = mailboxFailures;
        this.timestamp = timestamp;
        this.runningOptions = runningOptions;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.successfullyReprocessedMailCount;
    }

    public int getFailedReprocessedMailCount() {
        return this.failedReprocessedMailCount;
    }

    public List<ReindexingFailureDTO> getMessageFailures() {
        return this.messageFailures;
    }

    public Optional<List<String>> getMailboxFailures() {
        return this.mailboxFailures;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }

    public String getType() {
        return this.type;
    }

    public static class ReprocessingContextInformationForFullReindexingTask
    extends ReprocessingContextInformation {
        public static AdditionalInformationDTOModule<ReprocessingContextInformationForFullReindexingTask, DTO> module(MailboxId.Factory mailboxIdFactory) {
            return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReprocessingContextInformationForFullReindexingTask.class).convertToDTO(DTO.class).toDomainObjectConverter(dto -> new ReprocessingContextInformationForFullReindexingTask(dto.successfullyReprocessedMailCount, dto.failedReprocessedMailCount, ReprocessingContextInformationDTO.deserializeFailures(mailboxIdFactory, dto.messageFailures, (List)dto.mailboxFailures.orElse(ImmutableList.of())), dto.getTimestamp(), dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT))).toDTOConverter((details, type) -> new DTO(type, details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), Optional.empty(), Optional.of(ReprocessingContextInformationDTO.serializeFailures(details.failures())), Optional.of((List)details.failures().mailboxFailures().stream().map(MailboxId::serialize).collect(Guavate.toImmutableList())), details.timestamp(), Optional.of(RunningOptionsDTO.toDTO(details.getRunningOptions())))).typeName(FullReindexingTask.FULL_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
        }

        @VisibleForTesting
        public ReprocessingContextInformationForFullReindexingTask(int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp, ReIndexer.RunningOptions runningOptions) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp, runningOptions);
        }

        public static class DTO
        extends ReprocessingContextInformationDTO {
            DTO(@JsonProperty(value="type") String type, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") Optional<List<ReindexingFailureDTO>> failures, @JsonProperty(value="messageFailures") Optional<List<ReindexingFailureDTO>> messageFailures, @JsonProperty(value="mailboxFailures") Optional<List<String>> mailboxFailures, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
                super(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, messageFailures, mailboxFailures, timestamp, runningOptions);
            }
        }
    }

    public static class ReprocessingContextInformationForErrorRecoveryIndexationTask
    extends ReprocessingContextInformation {
        public static AdditionalInformationDTOModule<ReprocessingContextInformationForErrorRecoveryIndexationTask, DTO> module(MailboxId.Factory mailboxIdFactory) {
            return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReprocessingContextInformationForErrorRecoveryIndexationTask.class).convertToDTO(DTO.class).toDomainObjectConverter(dto -> new ReprocessingContextInformationForErrorRecoveryIndexationTask(dto.successfullyReprocessedMailCount, dto.failedReprocessedMailCount, ReprocessingContextInformationDTO.deserializeFailures(mailboxIdFactory, dto.messageFailures, (List)dto.mailboxFailures.orElse(ImmutableList.of())), dto.getTimestamp(), dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT))).toDTOConverter((details, type) -> new DTO(type, details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), Optional.empty(), Optional.of(ReprocessingContextInformationDTO.serializeFailures(details.failures())), Optional.of((List)details.failures().mailboxFailures().stream().map(MailboxId::serialize).collect(Guavate.toImmutableList())), details.timestamp(), Optional.of(RunningOptionsDTO.toDTO(details.getRunningOptions())))).typeName(ErrorRecoveryIndexationTask.PREVIOUS_FAILURES_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
        }

        @VisibleForTesting
        public ReprocessingContextInformationForErrorRecoveryIndexationTask(int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp, ReIndexer.RunningOptions runningOptions) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp, runningOptions);
        }

        public static class DTO
        extends ReprocessingContextInformationDTO {
            DTO(@JsonProperty(value="type") String type, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") Optional<List<ReindexingFailureDTO>> failures, @JsonProperty(value="messageFailures") Optional<List<ReindexingFailureDTO>> messageFailures, @JsonProperty(value="mailboxFailures") Optional<List<String>> mailboxFailures, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
                super(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, messageFailures, mailboxFailures, timestamp, runningOptions);
            }
        }
    }

    public static class ReindexingFailureDTO {
        private final String mailboxId;
        private final List<Long> uids;

        private ReindexingFailureDTO(@JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="uids") List<Long> uids) {
            this.mailboxId = mailboxId;
            this.uids = uids;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }

        public List<Long> getUids() {
            return this.uids;
        }
    }
}

