/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.github.steveash.guavate.Guavate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.mail.utils.ApplicableFlagCalculator;

public class InMemoryMessageMapper
extends AbstractMessageMapper {
    private final Map<InMemoryId, Map<MessageUid, MailboxMessage>> mailboxByUid = new ConcurrentHashMap<InMemoryId, Map<MessageUid, MailboxMessage>>(256);
    private static final int INITIAL_SIZE = 256;

    public InMemoryMessageMapper(MailboxSession session, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        super(session, uidProvider, modSeqProvider);
    }

    private Map<MessageUid, MailboxMessage> getMembershipByUidForMailbox(Mailbox mailbox) {
        return this.getMembershipByUidForMailbox(mailbox.getMailboxId());
    }

    private Map<MessageUid, MailboxMessage> getMembershipByUidForMailbox(MailboxId mailboxId) {
        return this.getMembershipByUidForId((InMemoryId)mailboxId);
    }

    private Map<MessageUid, MailboxMessage> getMembershipByUidForId(InMemoryId id) {
        Map<MessageUid, MailboxMessage> membershipByUid = this.mailboxByUid.get(id);
        if (membershipByUid == null) {
            membershipByUid = new ConcurrentHashMap<MessageUid, MailboxMessage>(256);
            this.mailboxByUid.put(id, membershipByUid);
        }
        return membershipByUid;
    }

    public long countMessagesInMailbox(Mailbox mailbox) {
        MailboxId mailboxId = mailbox.getMailboxId();
        return this.countMessagesInMailbox(mailboxId);
    }

    private int countMessagesInMailbox(MailboxId mailboxId) {
        return this.getMembershipByUidForMailbox(mailboxId).size();
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) {
        MailboxId mailboxId = mailbox.getMailboxId();
        return this.countUnseenMessagesInMailbox(mailboxId);
    }

    private long countUnseenMessagesInMailbox(MailboxId mailboxId) {
        return this.getMembershipByUidForMailbox(mailboxId).values().stream().filter(Predicate.not(MailboxMessage::isSeen)).count();
    }

    public void delete(Mailbox mailbox, MailboxMessage message) {
        this.getMembershipByUidForMailbox(mailbox).remove(message.getUid());
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        InMemoryId originalMailboxId = (InMemoryId)original.getMailboxId();
        MessageUid uid = original.getUid();
        MessageMetaData messageMetaData = this.copy(mailbox, original);
        this.getMembershipByUidForId(originalMailboxId).remove(uid);
        return messageMetaData;
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType ftype, int max) {
        List<Object> results = new ArrayList<MailboxMessage>(this.getMembershipByUidForMailbox(mailbox).values());
        results.removeIf(mailboxMessage -> !set.includes(mailboxMessage.getUid()));
        Collections.sort(results);
        if (max > 0 && results.size() > max) {
            results = results.subList(0, max);
        }
        return results.iterator();
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) {
        return (List)this.getMembershipByUidForMailbox(mailbox).values().stream().filter(MailboxMessage::isRecent).map(MailboxMessage::getUid).sorted().collect(Guavate.toImmutableList());
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) {
        ArrayList<MailboxMessage> memberships = new ArrayList<MailboxMessage>(this.getMembershipByUidForMailbox(mailbox).values());
        Collections.sort(memberships);
        return memberships.stream().filter(Predicate.not(MailboxMessage::isSeen)).findFirst().map(MailboxMessage::getUid).orElse(null);
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox mailbox, MessageRange messageRange) {
        ArrayList<MessageUid> filteredResult = new ArrayList<MessageUid>();
        Iterator<MailboxMessage> it = this.findInMailbox(mailbox, messageRange, MessageMapper.FetchType.Metadata, -1);
        while (it.hasNext()) {
            MailboxMessage member = it.next();
            if (!member.isDeleted()) continue;
            filteredResult.add(member.getUid());
        }
        return filteredResult;
    }

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox mailbox, List<MessageUid> uids) {
        return (Map)this.getMembershipByUidForMailbox(mailbox).values().stream().filter(message -> uids.contains(message.getUid())).peek(message -> this.delete(mailbox, (MailboxMessage)message)).collect(Guavate.toImmutableMap(MailboxMessage::getUid, MailboxMessage::metaData));
    }

    public Flags getApplicableFlag(Mailbox mailbox) {
        return new ApplicableFlagCalculator(this.getMembershipByUidForId((InMemoryId)mailbox.getMailboxId()).values()).computeApplicableFlags();
    }

    public void deleteAll() {
        this.mailboxByUid.clear();
    }

    protected MessageMetaData copy(Mailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage original) throws MailboxException {
        SimpleMailboxMessage message = SimpleMailboxMessage.copy((MailboxId)mailbox.getMailboxId(), (MailboxMessage)original);
        message.setUid(uid);
        message.setModSeq(modSeq);
        Flags flags = original.createFlags();
        flags.add(Flags.Flag.RECENT);
        message.setFlags(flags);
        return this.save(mailbox, (MailboxMessage)message);
    }

    public MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        SimpleMailboxMessage copy = SimpleMailboxMessage.copy((MailboxId)mailbox.getMailboxId(), (MailboxMessage)message);
        copy.setUid(message.getUid());
        copy.setModSeq(message.getModSeq());
        this.getMembershipByUidForMailbox(mailbox).put(message.getUid(), (MailboxMessage)copy);
        return message.metaData();
    }

    protected void begin() {
    }

    protected void commit() {
    }

    protected void rollback() {
    }
}

