/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class DeleCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"DELE");
    private static final Response SYNTAX_ERROR = new POP3Response("-ERR", "Usage: DELE [mail number]").immutable();
    private static final Response DELETED = new POP3Response("+OK", "Message deleted").immutable();

    public Response onCommand(POP3Session session, Request request) {
        if (session.getHandlerState() == 2) {
            int num = 0;
            try {
                num = Integer.parseInt(request.getArgument());
            }
            catch (Exception e) {
                return SYNTAX_ERROR;
            }
            try {
                String uid;
                MessageMetaData meta = MessageMetaDataUtils.getMetaData(session, num);
                if (meta == null) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    return new POP3Response("-ERR", responseBuffer.toString());
                }
                List deletedUidList = session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElseGet(() -> {
                    ArrayList uidList = new ArrayList();
                    session.setAttachment(POP3Session.DELETED_UID_LIST, uidList, ProtocolSession.State.Transaction);
                    return uidList;
                });
                if (deletedUidList.contains(uid = meta.getUid())) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    return new POP3Response("-ERR", responseBuffer.toString());
                }
                deletedUidList.add(uid);
                return DELETED;
            }
            catch (IndexOutOfBoundsException iob) {
                StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                return new POP3Response("-ERR", responseBuffer.toString());
            }
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

