/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.james.core.Username;
import org.apache.james.user.api.model.User;

public class ReadOnlyLDAPUser
implements User,
Serializable {
    private static final long serialVersionUID = -5201235065842464013L;
    private Username userName;
    private String userDN;
    private LdapContext ldapContext = null;

    private ReadOnlyLDAPUser() {
    }

    public ReadOnlyLDAPUser(Username userName, String userDN, LdapContext ldapContext) {
        this();
        this.userName = userName;
        this.userDN = userDN;
        this.ldapContext = ldapContext;
    }

    public Username getUserName() {
        return this.userName;
    }

    public boolean setPassword(String newPass) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPassword(String password) {
        boolean result = false;
        LdapContext ldapContext = null;
        try {
            ldapContext = this.ldapContext.newInstance(null);
            ldapContext.addToEnvironment("java.naming.security.authentication", "simple");
            ldapContext.addToEnvironment("java.naming.security.principal", this.userDN);
            ldapContext.addToEnvironment("java.naming.security.credentials", password);
            ldapContext.reconnect(null);
            result = true;
        }
        catch (NamingException namingException) {
        }
        finally {
            if (null != ldapContext) {
                try {
                    ldapContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return result;
    }
}

