/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.logger;

import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.metrics.logger.DefaultMetric;
import org.apache.james.metrics.logger.DefaultTimeMetric;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class DefaultMetricFactory
implements MetricFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultMetricFactory.class);

    public Metric generate(String name) {
        return new DefaultMetric(name);
    }

    public TimeMetric timer(String name) {
        return new DefaultTimeMetric(name);
    }

    public <T> Publisher<T> runPublishingTimerMetric(String name, Publisher<T> publisher) {
        TimeMetric timer = this.timer(name);
        return Flux.from(publisher).doOnComplete(() -> ((TimeMetric)timer).stopAndPublish());
    }

    public <T> Publisher<T> runPublishingTimerMetricLogP99(String name, Publisher<T> publisher) {
        TimeMetric timer = this.timer(name);
        return Flux.from(publisher).doOnComplete(() -> timer.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD));
    }
}

