/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamAssassinInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamAssassinInvoker.class);
    private static final int SPAM_INDEX = 1;
    private static final int HITS_INDEX = 3;
    private static final int REQUIRED_HITS_INDEX = 5;
    private static final String CRLF = "\r\n";
    private final MetricFactory metricFactory;
    private final String spamdHost;
    private final int spamdPort;

    public SpamAssassinInvoker(MetricFactory metricFactory, String spamdHost, int spamdPort) {
        this.metricFactory = metricFactory;
        this.spamdHost = spamdHost;
        this.spamdPort = spamdPort;
    }

    public SpamAssassinResult scanMail(MimeMessage message, Username username) throws MessagingException {
        return (SpamAssassinResult)this.metricFactory.runPublishingTimerMetric("spamAssassin-check", Throwing.supplier(() -> this.scanMailWithAdditionalHeaders(message, "User: " + username.asString())).sneakyThrow());
    }

    public SpamAssassinResult scanMail(MimeMessage message) throws MessagingException {
        return (SpamAssassinResult)this.metricFactory.runPublishingTimerMetric("spamAssassin-check", Throwing.supplier(() -> this.scanMailWithoutAdditionalHeaders(message)).sneakyThrow());
    }

    /*
     * Exception decompiling
     */
    private SpamAssassinResult scanMailWithAdditionalHeaders(MimeMessage message, String ... additionalHeaders) throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SpamAssassinResult scanMailWithoutAdditionalHeaders(MimeMessage message) throws MessagingException {
        return this.scanMailWithAdditionalHeaders(message, new String[0]);
    }

    private SpamAssassinResult processSpam(String line) {
        ArrayList elements = Lists.newArrayList((Iterable)Splitter.on((char)' ').split((CharSequence)line));
        return this.builderFrom(elements).hits((String)elements.get(3)).requiredHits((String)elements.get(5)).build();
    }

    private SpamAssassinResult.Builder builderFrom(List<String> elements) {
        if (this.spam(elements.get(1))) {
            return SpamAssassinResult.asSpam();
        }
        return SpamAssassinResult.asHam();
    }

    private boolean spam(String string) {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (Exception e) {
            LOGGER.warn("Fail parsing spamassassin answer: " + string);
            return false;
        }
    }

    private boolean isSpam(String line) {
        return line.startsWith("Spam:");
    }

    public boolean learnAsSpam(InputStream message, Username username) throws MessagingException {
        return (Boolean)this.metricFactory.runPublishingTimerMetric("spamAssassin-spam-report", Throwing.supplier(() -> this.reportMessageAs(message, username, MessageClass.SPAM)).sneakyThrow());
    }

    public boolean learnAsHam(InputStream message, Username username) throws MessagingException {
        return (Boolean)this.metricFactory.runPublishingTimerMetric("spamAssassin-ham-report", Throwing.supplier(() -> this.reportMessageAs(message, username, MessageClass.HAM)).sneakyThrow());
    }

    /*
     * Exception decompiling
     */
    private boolean reportMessageAs(InputStream message, Username username, MessageClass messageClass) throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasBeenSet(String line) {
        return line.startsWith("DidSet: ");
    }

    private static /* synthetic */ void lambda$scanMailWithAdditionalHeaders$2(PrintWriter writer, String header) {
        writer.write(header);
        writer.write(CRLF);
    }

    static enum MessageClass {
        HAM("ham"),
        SPAM("spam");

        private final String value;

        private MessageClass(String value) {
            this.value = value;
        }

        static /* synthetic */ String access$000(MessageClass x0) {
            return x0.value;
        }
    }
}

