/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.mailetcontainer.api.jmx.MailetManagementMBean;
import org.apache.mailet.MailetConfig;

public final class MailetManagement
extends StandardMBean
implements MailetManagementMBean {
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AtomicLong successCount = new AtomicLong(0L);
    private final AtomicLong fastestProcessing = new AtomicLong(-1L);
    private final AtomicLong slowestProcessing = new AtomicLong(-1L);
    private final AtomicLong lastProcessing = new AtomicLong(-1L);
    private final MailetConfig config;

    public MailetManagement(MailetConfig config) throws NotCompliantMBeanException {
        super(MailetManagementMBean.class);
        this.config = config;
    }

    public void update(long processTime, boolean success) {
        long fastest = this.fastestProcessing.get();
        if (fastest > processTime || fastest == -1L) {
            this.fastestProcessing.set(processTime);
        }
        if (this.slowestProcessing.get() < processTime) {
            this.slowestProcessing.set(processTime);
        }
        if (success) {
            this.successCount.incrementAndGet();
        } else {
            this.errorCount.incrementAndGet();
        }
        this.lastProcessing.set(processTime);
    }

    public String getMailetName() {
        return this.config.getMailetName();
    }

    public String[] getMailetParameters() {
        ArrayList<String> parameterList = new ArrayList<String>();
        Iterator iterator = this.config.getInitParameterNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = this.config.getInitParameter(name);
            parameterList.add(name + "=" + value);
        }
        return parameterList.toArray(new String[parameterList.size()]);
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getFastestProcessing() {
        return this.fastestProcessing.get();
    }

    public long getHandledMailCount() {
        return this.getErrorCount() + this.getSuccessCount();
    }

    public long getSlowestProcessing() {
        return this.slowestProcessing.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getLastProcessing() {
        return this.lastProcessing.get();
    }
}

