/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.mailetcontainer.api.jmx.MailProcessorManagementMBean;

public class MailProcessorManagement
extends StandardMBean
implements MailProcessorManagementMBean {
    private final String processorName;
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AtomicLong successCount = new AtomicLong(0L);
    private final AtomicLong fastestProcessing = new AtomicLong(-1L);
    private final AtomicLong slowestProcessing = new AtomicLong(-1L);
    private final AtomicLong lastProcessing = new AtomicLong(-1L);

    public MailProcessorManagement(String processorName) throws NotCompliantMBeanException {
        super(MailProcessorManagementMBean.class);
        this.processorName = processorName;
    }

    public void update(long processTime, boolean success) {
        long fastest = this.fastestProcessing.get();
        if (fastest > processTime || fastest == -1L) {
            this.fastestProcessing.set(processTime);
        }
        if (this.slowestProcessing.get() < processTime) {
            this.slowestProcessing.set(processTime);
        }
        if (success) {
            this.successCount.incrementAndGet();
        } else {
            this.errorCount.incrementAndGet();
        }
        this.lastProcessing.set(processTime);
    }

    public long getHandledMailCount() {
        return this.getSuccessCount() + this.getErrorCount();
    }

    public String getName() {
        return this.processorName;
    }

    public long getFastestProcessing() {
        return this.fastestProcessing.get();
    }

    public long getSlowestProcessing() {
        return this.slowestProcessing.get();
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getLastProcessing() {
        return this.lastProcessing.get();
    }
}

