/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.github.fge.lambdas.Throwing;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.mail.internet.ParseException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

class LocalResources {
    private static final EnumSet<Mapping.Type> ALIAS_TYPES = EnumSet.of(Mapping.Type.Alias, Mapping.Type.DomainAlias);
    private final UsersRepository localUsers;
    private final DomainList domains;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    LocalResources(UsersRepository localUsers, DomainList domains, RecipientRewriteTable recipientRewriteTable) {
        this.localUsers = localUsers;
        this.domains = domains;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    boolean isLocalServer(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            throw new RuntimeException("Unable to retrieve domains", e);
        }
    }

    boolean isLocalUser(String name) {
        if (name == null) {
            return false;
        }
        try {
            MailAddress mailAddress = Username.of((String)name).withDefaultDomain(this.domains.getDefaultDomain()).asMailAddress();
            return this.isLocalEmail(mailAddress);
        }
        catch (DomainListException e) {
            throw new RuntimeException("Unable to retrieve domains", e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse mail address", e);
        }
    }

    boolean isLocalEmail(MailAddress mailAddress) {
        if (mailAddress != null) {
            if (!this.isLocalServer(mailAddress.getDomain())) {
                return false;
            }
            try {
                return this.isLocaluser(mailAddress) || this.isLocalAlias(mailAddress);
            }
            catch (UsersRepositoryException e) {
                throw new RuntimeException("Unable to retrieve users", e);
            }
            catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException e) {
                throw new RuntimeException("Unable to retrieve RRTs", e);
            }
        }
        return false;
    }

    private boolean isLocaluser(MailAddress mailAddress) throws UsersRepositoryException {
        return this.localUsers.contains(this.localUsers.getUsername(mailAddress));
    }

    private boolean isLocalAlias(MailAddress mailAddress) throws UsersRepositoryException, RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        return this.recipientRewriteTable.getResolvedMappings(mailAddress.getLocalPart(), mailAddress.getDomain(), ALIAS_TYPES).asStream().map(mapping -> (MailAddress)mapping.asMailAddress().orElseThrow(() -> new IllegalStateException(String.format("Can not compute address for mapping %s", mapping.asString())))).anyMatch(Throwing.predicate(this::isLocaluser).sneakyThrow());
    }
}

