/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.jmx.MailSpoolerMBean;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class JamesMailSpooler
implements Disposable,
Configurable,
MailSpoolerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesMailSpooler.class);
    public static final String SPOOL_PROCESSING = "spoolProcessing";
    private int numThreads;
    private final AtomicInteger processingActive = new AtomicInteger(0);
    private final MetricFactory metricFactory;
    private final MailProcessor mailProcessor;
    private final MailQueueFactory<?> queueFactory;
    private reactor.core.Disposable disposable;
    private Scheduler spooler;
    private int parallelismLevel;
    private MailQueue queue;

    @Inject
    public JamesMailSpooler(MetricFactory metricFactory, MailProcessor mailProcessor, MailQueueFactory<?> queueFactory) {
        this.metricFactory = metricFactory;
        this.mailProcessor = mailProcessor;
        this.queueFactory = queueFactory;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.numThreads = config.getInt("threads", 100);
        this.parallelismLevel = Math.max(1, this.numThreads - 2);
    }

    @PostConstruct
    public void init() {
        LOGGER.info("init...");
        this.queue = this.queueFactory.createQueue(MailQueueFactory.SPOOL);
        this.spooler = Schedulers.fromExecutor((Executor)Executors.newFixedThreadPool(this.numThreads, (ThreadFactory)NamedThreadFactory.withName((String)"spooler")));
        LOGGER.info("uses {} Thread(s)", (Object)this.numThreads);
        this.run();
    }

    private void run() {
        LOGGER.info("Queue={}", (Object)this.queue);
        this.disposable = Flux.from((Publisher)this.queue.deQueue()).flatMap(item -> this.handleOnQueueItem((MailQueue.MailQueueItem)item).subscribeOn(this.spooler), this.parallelismLevel).onErrorContinue((throwable, item) -> LOGGER.error("Exception processing mail while spooling {}", item, throwable)).subscribeOn(this.spooler).subscribe();
    }

    private Mono<Void> handleOnQueueItem(MailQueue.MailQueueItem queueItem) {
        TimeMetric timeMetric = this.metricFactory.timer(SPOOL_PROCESSING);
        try {
            return Mono.fromCallable(this.processingActive::incrementAndGet).flatMap(ignore -> this.processMail(queueItem).subscribeOn(this.spooler)).doOnSuccess(any -> timeMetric.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD)).doOnSuccess(any -> this.processingActive.decrementAndGet());
        }
        catch (Throwable e) {
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Void> processMail(MailQueue.MailQueueItem queueItem) {
        return Mono.using(() -> ((MailQueue.MailQueueItem)queueItem).getMail(), resource -> Mono.just((Object)resource).doOnNext(mail -> LOGGER.debug("==== Begin processing mail {} ====", (Object)mail.getName())).map(mail -> this.performProcessMail(queueItem, (Mail)mail)).doOnNext(mail -> LOGGER.debug("==== End processing mail {} ====", (Object)mail.getName())), LifecycleUtil::dispose).then();
    }

    private Mail performProcessMail(MailQueue.MailQueueItem queueItem, Mail mail) {
        try {
            this.mailProcessor.service(mail);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Thread has been interrupted");
            }
            queueItem.done(true);
        }
        catch (Exception e) {
            try {
                queueItem.done(false);
            }
            catch (MailQueue.MailQueueException ex) {
                throw new RuntimeException(e);
            }
        }
        return mail;
    }

    @PreDestroy
    public void dispose() {
        LOGGER.info("start dispose() ...");
        this.disposable.dispose();
        this.spooler.dispose();
        try {
            this.queue.close();
        }
        catch (IOException e) {
            LOGGER.debug("error closing queue", (Throwable)e);
        }
        LOGGER.info("thread shutdown completed.");
    }

    public int getThreadCount() {
        return this.numThreads;
    }

    public int getCurrentSpoolCount() {
        return this.processingActive.get();
    }
}

