/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.util.Comparator;
import java.util.Objects;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;

public class MailboxMetaData
implements Comparable<MailboxMetaData> {
    public static final Comparator<MailboxMetaData> COMPARATOR = Comparator.comparing(metadata -> metadata.getPath().isInbox()).reversed().thenComparing(metadata -> metadata.getPath().getName());
    private final MailboxPath path;
    private final char delimiter;
    private final Children inferiors;
    private final Selectability selectability;
    private final MailboxId mailboxId;
    private final MailboxACL resolvedAcls;
    private final MailboxCounters counters;

    public static MailboxMetaData unselectableMailbox(MailboxPath path, MailboxId mailboxId, char delimiter) {
        return new MailboxMetaData(path, mailboxId, delimiter, Children.CHILDREN_ALLOWED_BUT_UNKNOWN, Selectability.NONE, new MailboxACL(), MailboxCounters.builder().mailboxId(mailboxId).count(0L).unseen(0L).build());
    }

    public MailboxMetaData(MailboxPath path, MailboxId mailboxId, char delimiter, Children inferiors, Selectability selectability, MailboxACL resolvedAcls, MailboxCounters counters) {
        this.path = path;
        this.mailboxId = mailboxId;
        this.delimiter = delimiter;
        this.inferiors = inferiors;
        this.selectability = selectability;
        this.resolvedAcls = resolvedAcls;
        this.counters = counters;
    }

    public MailboxCounters getCounters() {
        return this.counters;
    }

    public MailboxACL getResolvedAcls() {
        return this.resolvedAcls;
    }

    public final Children inferiors() {
        return this.inferiors;
    }

    public final Selectability getSelectability() {
        return this.selectability;
    }

    public char getHierarchyDelimiter() {
        return this.delimiter;
    }

    public MailboxPath getPath() {
        return this.path;
    }

    public MailboxId getId() {
        return this.mailboxId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxMetaData) {
            MailboxMetaData that = (MailboxMetaData)o;
            return Objects.equals(this.path, that.path);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.path);
    }

    @Override
    public int compareTo(MailboxMetaData o) {
        return COMPARATOR.compare(this, o);
    }

    public static enum Children {
        NO_INFERIORS,
        CHILDREN_ALLOWED_BUT_UNKNOWN,
        HAS_CHILDREN,
        HAS_NO_CHILDREN;

    }

    public static enum Selectability {
        NONE,
        MARKED,
        UNMARKED,
        NOSELECT;

    }
}

