/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.user;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Set;
import org.apache.james.core.Username;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class InMemorySubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private final Table<Username, String, ValueHolder> subscriptionsByUser = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Subscription subscription) {
        Table<Username, String, ValueHolder> table = this.subscriptionsByUser;
        synchronized (table) {
            this.subscriptionsByUser.remove((Object)subscription.getUser(), (Object)subscription.getMailbox());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscription> findSubscriptionsForUser(Username user) {
        Table<Username, String, ValueHolder> table = this.subscriptionsByUser;
        synchronized (table) {
            Set subscriptions = this.subscriptionsByUser.row((Object)user).keySet();
            return (List)subscriptions.stream().map(mailbox -> new Subscription(user, mailbox)).collect(Guavate.toImmutableList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Subscription subscription) {
        Table<Username, String, ValueHolder> table = this.subscriptionsByUser;
        synchronized (table) {
            this.subscriptionsByUser.put((Object)subscription.getUser(), (Object)subscription.getMailbox(), (Object)ValueHolder.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Table<Username, String, ValueHolder> table = this.subscriptionsByUser;
        synchronized (table) {
            this.subscriptionsByUser.clear();
        }
    }

    public void endRequest() {
    }

    private static enum ValueHolder {
        INSTANCE;

    }
}

