/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.transaction.Mapper;
import reactor.core.publisher.Mono;

public class InMemoryMailboxMapper
implements MailboxMapper {
    private static final int INITIAL_SIZE = 128;
    private final ConcurrentHashMap<MailboxPath, Mailbox> mailboxesByPath;
    private final AtomicLong mailboxIdGenerator = new AtomicLong();

    public InMemoryMailboxMapper() {
        this.mailboxesByPath = new ConcurrentHashMap(128);
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        this.mailboxesByPath.remove(mailbox.generateAssociatedPath());
    }

    public void deleteAll() throws MailboxException {
        this.mailboxesByPath.clear();
    }

    public synchronized Mono<Mailbox> findMailboxByPath(MailboxPath path) {
        Mailbox result = this.mailboxesByPath.get(path);
        return Mono.justOrEmpty((Object)result).map(Mailbox::new);
    }

    public synchronized Mailbox findMailboxById(MailboxId id) throws MailboxException {
        InMemoryId mailboxId = (InMemoryId)id;
        for (Mailbox mailbox : this.mailboxesByPath.values()) {
            if (!mailbox.getMailboxId().equals(mailboxId)) continue;
            return new Mailbox(mailbox);
        }
        throw new MailboxNotFoundException((MailboxId)mailboxId);
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) {
        return (List)this.mailboxesByPath.values().stream().filter(arg_0 -> ((MailboxQuery.UserBound)query).matches(arg_0)).map(Mailbox::new).collect(Guavate.toImmutableList());
    }

    public Mailbox create(MailboxPath mailboxPath, UidValidity uidValidity) throws MailboxException {
        InMemoryId id = InMemoryId.of(this.mailboxIdGenerator.incrementAndGet());
        Mailbox mailbox = new Mailbox(mailboxPath, uidValidity, (MailboxId)id);
        this.saveMailbox(mailbox);
        return mailbox;
    }

    public MailboxId rename(Mailbox mailbox) throws MailboxException {
        Preconditions.checkNotNull((Object)mailbox.getMailboxId(), (Object)"A mailbox we want to rename should have a defined mailboxId");
        InMemoryId id = (InMemoryId)mailbox.getMailboxId();
        Mailbox mailboxWithPreviousName = this.findMailboxById(id);
        this.saveMailbox(mailbox);
        this.mailboxesByPath.remove(mailboxWithPreviousName.generateAssociatedPath());
        return mailbox.getMailboxId();
    }

    private void saveMailbox(Mailbox mailbox) throws MailboxException {
        Mailbox previousMailbox = this.mailboxesByPath.putIfAbsent(mailbox.generateAssociatedPath(), mailbox);
        if (previousMailbox != null) {
            throw new MailboxExistsException(mailbox.getName());
        }
    }

    public void endRequest() {
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException {
        String mailboxName = mailbox.getName() + delimiter;
        return this.mailboxesByPath.values().stream().anyMatch(box -> this.belongsToSameUser(mailbox, (Mailbox)box) && box.getName().startsWith(mailboxName));
    }

    private boolean belongsToSameUser(Mailbox mailbox, Mailbox otherMailbox) {
        return Objects.equal((Object)mailbox.getNamespace(), (Object)otherMailbox.getNamespace()) && Objects.equal((Object)mailbox.getUser(), (Object)otherMailbox.getUser());
    }

    public List<Mailbox> list() throws MailboxException {
        return new ArrayList<Mailbox>(this.mailboxesByPath.values());
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)transaction.run();
    }

    public ACLDiff updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) throws MailboxException {
        MailboxACL oldACL = mailbox.getACL();
        MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
        this.mailboxesByPath.get(mailbox.generateAssociatedPath()).setACL(newACL);
        return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
    }

    public ACLDiff setACL(Mailbox mailbox, MailboxACL mailboxACL) throws MailboxException {
        MailboxACL oldMailboxAcl = mailbox.getACL();
        this.mailboxesByPath.get(mailbox.generateAssociatedPath()).setACL(mailboxACL);
        return ACLDiff.computeDiff((MailboxACL)oldMailboxAcl, (MailboxACL)mailboxACL);
    }

    public List<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) throws MailboxException {
        return (List)this.mailboxesByPath.values().stream().filter(mailbox -> this.hasRightOn((Mailbox)mailbox, userName, right)).collect(Guavate.toImmutableList());
    }

    private Boolean hasRightOn(Mailbox mailbox, Username userName, MailboxACL.Right right) {
        return Optional.ofNullable((MailboxACL.Rfc4314Rights)mailbox.getACL().ofPositiveNameType(MailboxACL.NameType.user).get(MailboxACL.EntryKey.createUserEntryKey((Username)userName))).map(rights -> rights.contains(right)).orElse(false);
    }
}

