/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mdn.fields.AddressType;
import org.apache.james.mdn.fields.Field;
import org.apache.james.mdn.fields.Text;

public class OriginalRecipient
implements Field {
    private static final String FIELD_NAME = "Original-Recipient";
    private final Text originalRecipient;
    private final AddressType addressType;

    public static OriginalRecipient ofUnknown(Text address) {
        return new OriginalRecipient(AddressType.UNKNOWN, address);
    }

    public static Builder builder() {
        return new Builder();
    }

    private OriginalRecipient(AddressType addressType, Text originalRecipient) {
        this.addressType = addressType;
        this.originalRecipient = originalRecipient;
    }

    public Text getOriginalRecipient() {
        return this.originalRecipient;
    }

    public AddressType getAddressType() {
        return this.addressType;
    }

    public final boolean equals(Object o) {
        if (o instanceof OriginalRecipient) {
            OriginalRecipient that = (OriginalRecipient)o;
            return Objects.equals(this.originalRecipient, that.originalRecipient) && Objects.equals(this.addressType, that.addressType);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.originalRecipient, this.addressType);
    }

    @Override
    public String formattedValue() {
        return "Original-Recipient: " + this.addressType.getType() + "; " + this.originalRecipient.formatted();
    }

    public String toString() {
        return this.formattedValue();
    }

    public static class Builder {
        private Optional<AddressType> addressType = Optional.empty();
        private Text originalRecipient;

        private Builder() {
        }

        public Builder addressType(AddressType addressType) {
            this.addressType = Optional.of(addressType);
            return this;
        }

        public Builder originalRecipient(Text originalRecipient) {
            this.originalRecipient = originalRecipient;
            return this;
        }

        public OriginalRecipient build() {
            Preconditions.checkNotNull((Object)this.originalRecipient);
            return new OriginalRecipient(this.addressType.orElse(AddressType.RFC_822), this.originalRecipient);
        }
    }
}

